/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.documents.repository;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import pt.digitalis.dif.documents.repository.LuceneConfiguration;
import pt.digitalis.dif.utils.extensions.document.AbstractDocumentRepository;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryEntry;
import pt.digitalis.dif.utils.extensions.document.MaximumDocumentSizeException;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;
import pt.digitalis.utils.common.DateUtils;
import pt.digitalis.utils.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentRepositoryLuceneImpl
extends AbstractDocumentRepository {
    private static Long documentId;
    private static final String INDEX_SUFFIX_DIR = "lucene_index";
    public static IndexWriter writer;
    StandardAnalyzer analizer = new StandardAnalyzer();
    File indexDirectory;
    private final String indexPath;
    protected ILogWrapper logger;
    private final Integer maxDocumentSize;

    public DocumentRepositoryLuceneImpl() {
        this(LuceneConfiguration.getInstance().getMaxDocumentSize());
    }

    public DocumentRepositoryLuceneImpl(Integer maxDocumentSize) {
        this(StringUtils.isEmpty((String)LuceneConfiguration.getInstance().getIndexPath()) ? System.getProperty("user.home") + "/" + INDEX_SUFFIX_DIR : LuceneConfiguration.getInstance().getIndexPath(), maxDocumentSize);
    }

    public DocumentRepositoryLuceneImpl(String indexPath, Integer maxDocumentSize) {
        this.indexPath = indexPath;
        this.logger = DIFLogger.getLogger();
        this.maxDocumentSize = maxDocumentSize;
        this.initialize();
    }

    public synchronized DocumentRepositoryEntry addDocument(DocumentRepositoryEntry document) throws MaximumDocumentSizeException {
        return this.addDocument(document, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentRepositoryEntry addDocument(DocumentRepositoryEntry document, Boolean ignoreSizeLimit) throws MaximumDocumentSizeException {
        document.setId(this.getNextDocumentId());
        Document doc = this.buildDocument(document);
        if (ignoreSizeLimit.booleanValue() || this.maxDocumentSize == null || document.getBytes().length / 1024 <= this.maxDocumentSize) {
            try {
                writer.addDocument(doc);
                writer.commit();
            }
            catch (CorruptIndexException e) {
                e.printStackTrace();
            }
            catch (LockObtainFailedException e) {
                this.recoverFromCorrupt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                document.setId(new Long(doc.get(DocumentRepositoryEntry.Fields.ID.toString())));
            }
        } else {
            throw new MaximumDocumentSizeException("The Document exceeds the maximum size of " + this.maxDocumentSize + "Kb", this.maxDocumentSize);
        }
        return document;
    }

    private synchronized Document buildDocument(DocumentRepositoryEntry document) {
        Document luceneDocument = new Document();
        luceneDocument.add((Fieldable)new Field(DocumentRepositoryEntry.Fields.ID.toString(), document.getId().toString(), Field.Store.YES, Field.Index.ANALYZED));
        if (document.getCreatorID() != null) {
            luceneDocument.add((Fieldable)new Field(DocumentRepositoryEntry.Fields.CREATOR.toString(), document.getCreatorID(), Field.Store.YES, Field.Index.ANALYZED));
        }
        if (document.getName() != null) {
            luceneDocument.add((Fieldable)new Field(DocumentRepositoryEntry.Fields.NAME.toString(), document.getName(), Field.Store.YES, Field.Index.ANALYZED));
        }
        if (document.getDescription() != null) {
            luceneDocument.add((Fieldable)new Field(DocumentRepositoryEntry.Fields.DESCRIPTION.toString(), document.getDescription(), Field.Store.YES, Field.Index.ANALYZED));
        }
        luceneDocument.add((Fieldable)new Field(DocumentRepositoryEntry.Fields.FILENAME.toString(), document.getFileName(), Field.Store.YES, Field.Index.ANALYZED));
        luceneDocument.add((Fieldable)new Field(DocumentRepositoryEntry.Fields.CREATION_DATE.toString(), DateUtils.dateToString((Date)document.getCreationDate()), Field.Store.YES, Field.Index.ANALYZED));
        luceneDocument.add((Fieldable)new Field(DocumentRepositoryEntry.Fields.MIMETYPE.toString(), document.getMimeType(), Field.Store.YES, Field.Index.ANALYZED));
        luceneDocument.add((Fieldable)new Field(DocumentRepositoryEntry.Fields.BYTE_CONTENT.toString(), document.getBytes(), Field.Store.YES));
        return luceneDocument;
    }

    public synchronized void deleteDocument(Long id) {
        try {
            Term term = new Term(DocumentRepositoryEntry.Fields.ID.toString(), id.toString());
            writer.deleteDocuments(term);
            writer.commit();
        }
        catch (CorruptIndexException e) {
            this.recoverFromCorrupt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized DocumentRepositoryEntry getDocument(Long id) {
        return this.getDocument(id, false);
    }

    public DocumentRepositoryEntry getDocument(Long id, boolean lazyLoadFile) {
        if (id == null) {
            return null;
        }
        ArrayList<DocumentRepositoryEntry> docs = this.search(DocumentRepositoryEntry.Fields.ID.toString(), id.toString());
        if (docs.size() != 0) {
            return docs.get(0);
        }
        return null;
    }

    public List<DocumentRepositoryEntry> getDocumentByOriginalFileName(String originalFileName) {
        return this.search(DocumentRepositoryEntry.Fields.FILENAME.toString(), originalFileName);
    }

    public List<DocumentRepositoryEntry> getDocumentsByCreator(String creatorUserID) {
        ArrayList<DocumentRepositoryEntry> documents = this.search(DocumentRepositoryEntry.Fields.CREATOR.toString(), creatorUserID);
        return documents;
    }

    private synchronized Long getNextDocumentId() {
        while (this.getDocument(documentId = Long.valueOf(documentId + 1L)) != null) {
        }
        if (documentId % 50L == 0L) {
            try {
                writer.optimize();
            }
            catch (CorruptIndexException e) {
                this.logger.debug((Object)"Error while trying to optimize the lucene index");
            }
            catch (IOException e) {
                this.logger.debug((Object)"Error while trying to optimize the lucene index");
            }
        }
        return documentId;
    }

    private synchronized void initializaDocumentId(Long value) {
        documentId = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.logger = DIFLogger.getLogger();
        if (writer == null) {
            IndexWriter tempWriter = null;
            this.indexDirectory = new File(this.indexPath);
            boolean exists = this.indexDirectory.exists();
            try {
                if (exists) {
                    this.unLockIndex();
                }
                tempWriter = new IndexWriter(this.indexPath, (Analyzer)this.analizer, !exists, IndexWriter.MaxFieldLength.LIMITED);
                tempWriter.setMaxFieldLength(1);
                tempWriter.optimize();
                this.initializaDocumentId(new Long(tempWriter.maxDoc()));
                writer = tempWriter;
            }
            catch (CorruptIndexException e) {
                this.recoverFromCorrupt();
            }
            catch (LockObtainFailedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.logger.debug((Object)"The writer was created");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void recoverFromCorrupt() {
        this.logger.debug((Object)"The Index is corrupt, starting recover!");
        CheckIndex.Status status = null;
        try {
            FSDirectory directory = FSDirectory.getDirectory((String)this.indexPath);
            CheckIndex checkIndex = new CheckIndex((Directory)directory);
            status = checkIndex.checkIndex();
            checkIndex.fixIndex(status);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.logger.debug((Object)"The Index recovery was finished!");
            if (status != null) {
                this.logger.debug((Object)("Bad Segments:" + status.numBadSegments));
            }
        }
    }

    private ArrayList<DocumentRepositoryEntry> search(String field, String value) {
        ArrayList<DocumentRepositoryEntry> documents = new ArrayList<DocumentRepositoryEntry>();
        int hitsPerPage = 1000;
        try {
            IndexSearcher searcher = new IndexSearcher(this.indexPath);
            TopDocCollector collector = new TopDocCollector(hitsPerPage);
            Query query = new QueryParser("", (Analyzer)this.analizer).parse(field + ":" + value);
            searcher.search(query, (HitCollector)collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            for (int i = 0; i < hits.length; ++i) {
                int docId = hits[i].doc;
                Document doc = searcher.doc(docId);
                try {
                    documents.add(new DocumentRepositoryEntry(new Long(doc.get(DocumentRepositoryEntry.Fields.ID.toString())), doc.get(DocumentRepositoryEntry.Fields.CREATOR.toString()), doc.get(DocumentRepositoryEntry.Fields.NAME.toString()), doc.get(DocumentRepositoryEntry.Fields.DESCRIPTION.toString()), doc.get(DocumentRepositoryEntry.Fields.FILENAME.toString()), DateUtils.stringToDate((String)doc.get(DocumentRepositoryEntry.Fields.CREATION_DATE.toString())), doc.get(DocumentRepositoryEntry.Fields.MIMETYPE.toString()), doc.getBinaryValue(DocumentRepositoryEntry.Fields.BYTE_CONTENT.toString())));
                    continue;
                }
                catch (java.text.ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (CorruptIndexException e) {
            this.recoverFromCorrupt();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return documents;
    }

    private synchronized void unLockIndex() {
        try {
            if (IndexWriter.isLocked((String)this.indexPath)) {
                this.logger.debug((Object)"Starting unlock Writer!");
                FSDirectory directory = FSDirectory.getDirectory((String)this.indexPath);
                IndexWriter.unlock((Directory)directory);
                this.logger.debug((Object)"The writer was unlocked successfully!");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized DocumentRepositoryEntry updateDocument(DocumentRepositoryEntry document) {
        try {
            writer.updateDocument(new Term(DocumentRepositoryEntry.Fields.ID.toString(), document.getId().toString()), this.buildDocument(document));
            writer.commit();
        }
        catch (CorruptIndexException e) {
            this.recoverFromCorrupt();
        }
        catch (LockObtainFailedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

