package pt.digitalis.dif.documents.repository;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Jun 22, 2009
 */
@ConfigID("Lucene")
@ConfigSectionID("Repository")
public class LuceneConfiguration {

    /**
     * LuceneConfigurations instance.
     */
    private static LuceneConfiguration configuration;

    /**
     * Get the <code>LuceneConfiguration</code>.
     *
     * @return the LuceneConfiguration instance.
     */
    @ConfigIgnore
    public static LuceneConfiguration getInstance()
    {

        if (configuration == null)
        {
            configuration = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                    .readConfiguration(LuceneConfiguration.class);
        }
        return configuration;
    }

    /** the indexPath */
    private String indexPath;

    /** the maximum Document size */
    private Integer maxDocumentSize;

    /**
     * Get the IndexPath
     *
     * @return the indexPath
     */
    @ConfigDefault("")
    public String getIndexPath()
    {
        return this.indexPath;
    }

    /**
     * Inspector for the 'maxDocumentSize' attribute.
     *
     * @return the maxDocumentSize value
     */
    @ConfigDefault("1024")
    public Integer getMaxDocumentSize()
    {
        return maxDocumentSize;
    }

    /**
     * Modifier for the 'indexPath' attribute.
     *
     * @param indexPath
     *            the new indexPath value to set
     */
    public void setIndexPath(String indexPath)
    {
        this.indexPath = indexPath;
    }

    /**
     * Modifier for the 'maxDocumentSize' attribute.
     *
     * @param maxDocumentSize
     *            the new maxDocumentSize value to set
     */
    public void setMaxDocumentSize(String maxDocumentSize)
    {
        if (maxDocumentSize != null && !"".equals(maxDocumentSize))
        {
            this.maxDocumentSize = new Integer(maxDocumentSize);
        }
    }
}
