package pt.digitalis.dif.identity.ioc;

import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.identity.repository.IdentityManagerDBImpl;
import pt.digitalis.dif.identity.repository.sanitycheck.CheckDIF2BDConfigurations;
import pt.digitalis.dif.sanitycheck.ISanityCheckTestSuite;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * Module definition for the identity manager.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/04/21
 */
public class IdentityDBModule implements IIoCModule
{

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {
        binder.bind(IIdentityManager.class, IdentityManagerDBImpl.class).withId(IdentityManagerDBImpl.NAME)
                .asSingleton();

        // Sanity checks
        binder.bind(ISanityCheckTestSuite.class, CheckDIF2BDConfigurations.class).withId("DBConfigurationsDIF2");
    }
}