/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.identity.repository;

import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 2012/10/11
 */
public class IdentityManagerDBException extends IdentityManagerException
{

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * @param exception
     */
    public IdentityManagerDBException(Exception exception)
    {
        this(null, exception);
    }

    /**
     * @param reason
     */
    public IdentityManagerDBException(String reason)
    {
        this(reason, null);
    }

    /**
     * @param reason
     * @param exception
     */
    public IdentityManagerDBException(String reason, Exception exception)
    {
        super(reason, exception);

        if (getCause() != null && getCause() instanceof DataSetException)
            super.setReadOnlyException(true);
    }
}
