package pt.digitalis.dif.identity.repository.sanitycheck;

import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.dem.managers.impl.model.IIdentityService;
import pt.digitalis.dif.identity.repository.IdentityManagerDBImpl;
import pt.digitalis.dif.ioc.DIFDefaultModulesConfiguration;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.sanitycheck.AbstractSanityCheckTestSuite;
import pt.digitalis.dif.sanitycheck.ExecutionResult;
import pt.digitalis.dif.sanitycheck.TestResult;
import pt.digitalis.dif.sanitycheck.annotations.SanityCheckTest;

/**
 * The Class CheckDIF2BDConfigurations.
 *
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 6 de Jul de 2011
 */
public class CheckDIF2BDConfigurations extends AbstractSanityCheckTestSuite
{

    /** The identity service. */
    IIdentityService identityService = DIFIoCRegistry.getRegistry().getImplementation(IIdentityService.class);

    /**
     * @see pt.digitalis.dif.sanitycheck.AbstractSanityCheckTestSuite#isActive()
     */
    @Override
    public boolean isActive()
    {
        return IdentityManagerDBImpl.NAME.equals(DIFDefaultModulesConfiguration.getInstance()
                .getDefaultImplementationIDFor(IIdentityManager.class));
    }

    /**
     * Test sanity for <i>DB DIF2 Connection</i> Group.
     *
     * @return <code>SanityUnitResult</code>
     */
    @SanityCheckTest
    public TestResult test2DBDIF2Connection()
    {
        TestResult testResult;

        try
        {
            identityService.getUsersDataSet().query().count();
            testResult = new TestResult(ExecutionResult.PASSED);
        }
        catch (Exception e)
        {
            e.printStackTrace();

            testResult = new TestResult(ExecutionResult.FAILED);
            testResult.setErrorMessage(e.getMessage() + e.getCause());
        }

        return testResult;
    }

    /**
     * Test sanity for <i>DB DIF2 Default Group existence</i> Group.
     *
     * @return <code>SanityUnitResult</code>
     */
    @SanityCheckTest
    public TestResult test3DBDefaultGroupDN()
    {

        TestResult testResult = new TestResult(ExecutionResult.PASSED);

        // TODO: Implement this

        return testResult;
    }

    /**
     * Test sanity for <i>DB DIF2 Default Profile existence</i> Group.
     *
     * @return <code>SanityUnitResult</code>
     */
    @SanityCheckTest
    public TestResult test4DBDefaultprofileDN()
    {
        TestResult testResult = new TestResult(ExecutionResult.PASSED);

        // TODO: Implement this

        return testResult;
    }
}