/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.identity.ldap;

import pt.digitalis.dif.identity.ldap.LDAPUtilsImplementation;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

@ConfigID(value="dif2")
@ConfigSectionID(value="IdManagerConfigurations")
public class IdentityManagerLDAPConfigurations {
    private LDAPUtilsImplementation ldapUtilsImplementation;

    @ConfigDefault(value="ad")
    public LDAPUtilsImplementation getLdapUtilsImplementation() {
        return this.ldapUtilsImplementation;
    }

    public void setLdapUtilsImplementation(String newLDAPUtilsImplementation) {
        if (LDAPUtilsImplementation.AD.getIdTag().equals(newLDAPUtilsImplementation)) {
            this.ldapUtilsImplementation = LDAPUtilsImplementation.AD;
        } else if (LDAPUtilsImplementation.OPEN_LDAP.getIdTag().equals(newLDAPUtilsImplementation)) {
            this.ldapUtilsImplementation = LDAPUtilsImplementation.OPEN_LDAP;
        } else if (LDAPUtilsImplementation.OID.getIdTag().equals(newLDAPUtilsImplementation)) {
            this.ldapUtilsImplementation = LDAPUtilsImplementation.OID;
        } else {
            throw new RuntimeException("Illegal value for LDAP Utils implementation: " + newLDAPUtilsImplementation + "!! Use one of the following: " + LDAPUtilsImplementation.AD.getIdTag() + ", " + LDAPUtilsImplementation.OPEN_LDAP.getIdTag() + ", " + LDAPUtilsImplementation.OID.getIdTag() + ".");
        }
    }
}

