/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.identity.ldap.sanitycheck;

import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.identity.ldap.IdentityManagerLDAPImpl;
import pt.digitalis.dif.ioc.DIFDefaultModulesConfiguration;
import pt.digitalis.dif.sanitycheck.AbstractSanityCheckTestSuite;
import pt.digitalis.dif.sanitycheck.ExecutionResult;
import pt.digitalis.dif.sanitycheck.TestResult;
import pt.digitalis.dif.sanitycheck.annotations.SanityCheckTest;
import pt.digitalis.utils.ldap.LDAPGroup;
import pt.digitalis.utils.ldap.exception.LDAPOperationException;

public class CheckDIF2Groups
extends AbstractSanityCheckTestSuite {
    private final IdentityManagerLDAPImpl identityManagerImpl = new IdentityManagerLDAPImpl();

    public boolean isActive() {
        return "LDAP".equals(DIFDefaultModulesConfiguration.getInstance().getDefaultImplementationIDFor(IIdentityManager.class));
    }

    @SanityCheckTest
    public TestResult testGroupParents() {
        TestResult testResult;
        String errorMessage = "";
        try {
            for (LDAPGroup group : this.identityManagerImpl.getLDAPUtils().findAllGroups()) {
                if (group.getParentGroupDN().equals("N/A")) continue;
                try {
                    this.identityManagerImpl.getLDAPUtils().findGroupByDistinguishedName(group.getParentGroupDN());
                }
                catch (Exception e) {
                    errorMessage = "Could not access parent group \"" + group.getParentGroupDN() + "\", of the group \"" + group.getCommonName() + "\"! Exception: " + e.getMessage();
                }
            }
        }
        catch (LDAPOperationException e) {
            errorMessage = e.getMessage();
        }
        if (!"".equals(errorMessage)) {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 2);
            testResult = new TestResult(ExecutionResult.FAILED);
            testResult.setErrorMessage(errorMessage);
        } else {
            testResult = new TestResult(ExecutionResult.PASSED);
        }
        return testResult;
    }
}

