/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.identity.ldap.sanitycheck;

import java.util.Map;
import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.identity.ldap.IdentityManagerLDAPImpl;
import pt.digitalis.dif.ioc.DIFDefaultModulesConfiguration;
import pt.digitalis.dif.sanitycheck.AbstractSanityCheckTestSuite;
import pt.digitalis.dif.sanitycheck.ExecutionResult;
import pt.digitalis.dif.sanitycheck.TestResult;
import pt.digitalis.dif.sanitycheck.annotations.SanityCheckTest;
import pt.digitalis.utils.ldap.LDAPConfigurations;
import pt.digitalis.utils.ldap.exception.LDAPOperationException;

public class CheckDIF2LDAPConfigurations
extends AbstractSanityCheckTestSuite {
    private IdentityManagerLDAPImpl identityManagerImpl = new IdentityManagerLDAPImpl();

    public boolean isActive() {
        return "LDAP".equals(DIFDefaultModulesConfiguration.getInstance().getDefaultImplementationIDFor(IIdentityManager.class));
    }

    @SanityCheckTest
    public TestResult test1LdapAtttributesDIF2() {
        TestResult testResult;
        String errorMessage = "";
        LDAPConfigurations configurations = this.identityManagerImpl.getLDAPUtils().getConfigurations();
        if (configurations.getBaseSearchDN() == null || "".equals(configurations.getBaseSearchDN())) {
            errorMessage = errorMessage + "BaseSearchDN, ";
        }
        if (configurations.getBaseUserDN() == null || "".equals(configurations.getBaseUserDN())) {
            errorMessage = errorMessage + "BaseUserDN, ";
        }
        if (configurations.getBulkParametersAttributeName() == null || "".equals(configurations.getBulkParametersAttributeName())) {
            errorMessage = errorMessage + "ParametersAttributeName, ";
        }
        if (configurations.getDefaultGroupDN() == null || "".equals(configurations.getDefaultGroupDN())) {
            errorMessage = errorMessage + "DefaultGroupDN, ";
        }
        if (configurations.getDefaultProfileDN() == null || "".equals(configurations.getDefaultProfileDN())) {
            errorMessage = errorMessage + "DefaultProfileDN, ";
        }
        if (configurations.getHostName() == null || "".equals(configurations.getHostName())) {
            errorMessage = errorMessage + "HostName, ";
        }
        if (configurations.getPassword() == null || "".equals(configurations.getPassword())) {
            errorMessage = errorMessage + "Password, ";
        }
        if (configurations.getPort() == null || "".equals(configurations.getPort())) {
            errorMessage = errorMessage + "Port, ";
        }
        if (configurations.getSSLPort() == null || "".equals(configurations.getSSLPort())) {
            errorMessage = errorMessage + "SSLPort, ";
        }
        if (configurations.getUserDN() == null || "".equals(configurations.getUserDN())) {
            errorMessage = errorMessage + "UserDN, ";
        }
        if (!"".equals(errorMessage)) {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 2);
            testResult = new TestResult(ExecutionResult.FAILED);
            testResult.setErrorMessage(errorMessage);
        } else {
            testResult = new TestResult(ExecutionResult.PASSED);
        }
        return testResult;
    }

    @SanityCheckTest
    public TestResult test2LdapDIF2Connection() {
        TestResult testResult;
        try {
            this.identityManagerImpl.getLDAPUtils().findUserByDistinguishedName(this.identityManagerImpl.getLDAPUtils().getConfigurations().getUserDN());
            testResult = new TestResult(ExecutionResult.PASSED);
        }
        catch (LDAPOperationException e) {
            e.printStackTrace();
            testResult = new TestResult(ExecutionResult.FAILED);
            testResult.setErrorMessage(e.getMessage() + e.getCause());
        }
        return testResult;
    }

    @SanityCheckTest
    public TestResult test3LdapDefaultGroupDN() {
        TestResult testResult;
        try {
            this.identityManagerImpl.getLDAPUtils().findGroupByDistinguishedName(this.identityManagerImpl.getLDAPUtils().getConfigurations().getDefaultGroupDN());
            testResult = new TestResult(ExecutionResult.PASSED);
        }
        catch (LDAPOperationException e) {
            e.printStackTrace();
            testResult = new TestResult(ExecutionResult.FAILED);
            testResult.setErrorMessage(e.getMessage() + e.getCause());
        }
        return testResult;
    }

    @SanityCheckTest
    public TestResult test4LdapDefaultprofileDN() {
        TestResult testResult;
        try {
            this.identityManagerImpl.getLDAPUtils().findGroupByDistinguishedName(this.identityManagerImpl.getLDAPUtils().getConfigurations().getDefaultProfileDN());
            testResult = new TestResult(ExecutionResult.PASSED);
        }
        catch (LDAPOperationException e) {
            e.printStackTrace();
            testResult = new TestResult(ExecutionResult.FAILED);
            testResult.setErrorMessage(e.getMessage() + e.getCause());
        }
        return testResult;
    }

    @SanityCheckTest
    public TestResult test5LdapDIF2GroupMappings() {
        TestResult testResult;
        String errorMessage = "";
        Map groupMappings = this.identityManagerImpl.getLDAPUtils().getConfigurations().getGroupMappings();
        for (Map.Entry entry : groupMappings.entrySet()) {
            if (entry.getValue() == null || "".equals(entry.getValue())) continue;
            try {
                this.identityManagerImpl.getGroup((String)entry.getValue());
            }
            catch (IdentityManagerException e) {
                errorMessage = errorMessage + (String)entry.getKey() + ", ";
                e.printStackTrace();
            }
        }
        if (!"".equals(errorMessage)) {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 2);
            testResult = new TestResult(ExecutionResult.FAILED);
            testResult.setErrorMessage(errorMessage);
        } else {
            testResult = new TestResult(ExecutionResult.PASSED);
        }
        return testResult;
    }
}

