/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.identity.ldap;

import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigSectionID;
import pt.digitalis.utils.config.annotations.ConfigVirtualPathForNode;

/**
 * Defines configuration options for the LDAP-based identity manager.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/07/11
 */
@ConfigID("dif2")
@ConfigSectionID("IdManagerConfigurations")
@ConfigVirtualPathForNode("dif2/Integrations/LDAP Identity Provider/General")
public class IdentityManagerLDAPConfigurations {

    /** The active LDAPUtils implementation property */
    private LDAPUtilsImplementation ldapUtilsImplementation;

    /**
     * Getter for the active LDAPUtils implementation property.
     * 
     * @return the active LDAPUtils implementation
     */
    @ConfigDefault("ad")
    public LDAPUtilsImplementation getLdapUtilsImplementation()
    {
        return this.ldapUtilsImplementation;
    }

    /**
     * Setter for the active LDAPUtils implementation property.
     * 
     * @param newLDAPUtilsImplementation
     *            the new LDAPUtils implementation to set as a String.
     */
    public void setLdapUtilsImplementation(String newLDAPUtilsImplementation)
    {

        if (LDAPUtilsImplementation.AD.getIdTag().equals(newLDAPUtilsImplementation))
            this.ldapUtilsImplementation = LDAPUtilsImplementation.AD;
        else if (LDAPUtilsImplementation.OPEN_LDAP.getIdTag().equals(newLDAPUtilsImplementation))
            this.ldapUtilsImplementation = LDAPUtilsImplementation.OPEN_LDAP;
        else if (LDAPUtilsImplementation.OID.getIdTag().equals(newLDAPUtilsImplementation))
            this.ldapUtilsImplementation = LDAPUtilsImplementation.OID;
        else
            throw new RuntimeException("Illegal value for LDAP Utils implementation: " + newLDAPUtilsImplementation
                    + "!! Use one of the following: " + LDAPUtilsImplementation.AD.getIdTag() + ", "
                    + LDAPUtilsImplementation.OPEN_LDAP.getIdTag() + ", " + LDAPUtilsImplementation.OID.getIdTag()
                    + ".");
    }

}
