/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.identity.ldap;

import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.utils.ldap.exception.LDAPOperationReadOnlyException;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/08/11
 */
public class IdentityManagerLDAPException extends IdentityManagerException
{

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * @param exception
     */
    public IdentityManagerLDAPException(Exception exception)
    {
        this(null, exception);
    }

    /**
     * @param reason
     */
    public IdentityManagerLDAPException(String reason)
    {
        this(reason, null);
    }

    /**
     * @param reason
     * @param exception
     */
    public IdentityManagerLDAPException(String reason, Exception exception)
    {
        super(reason, exception);

        if (getCause() != null && getCause() instanceof LDAPOperationReadOnlyException)
            super.setReadOnlyException(true);
    }
}
