/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.identity.ldap;

/**
 * Defines the available LDAPUtils implementations.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/07/14
 */
public enum LDAPUtilsImplementation
{
    /** The MS Active Directory implementation. */
    AD,
    /** The Oracle OID implementation. */
    OID,
    /** The OpenLDAP implementation. */
    OPEN_LDAP;

    /**
     * Returns the LDAP Utils implementation ID tag.
     *
     * @return the current LDAP utils implementation ID tag
     */
    public String getIdTag()
    {
        switch (this)
        {
            case AD:
                return "ad";
            case OPEN_LDAP:
                return "open_ldap";
            case OID:
                return "oid";
        }
        /*
         * Untestable branch! Java languages obliges to have a return instruction outside the switch block, but to have
         * the execution flow to get here one would need to call the method with an inexistent enum value which is
         * obviously not possible. Move the return instruction to a default-branch inside the switch statement would not
         * solve the issue since the calling problem still exists. Converting the switch block on an if statement is the
         * same. Reflection offers no solution to this problem as well.
         */
        return null;
    }

    /**
     * @see java.lang.Enum#toString()
     */
    @Override
    public String toString()
    {
        return getIdTag();
    }
}
