package pt.digitalis.dif.identity.ldap.sanitycheck;

import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.identity.ldap.IdentityManagerLDAPImpl;
import pt.digitalis.dif.ioc.DIFDefaultModulesConfiguration;
import pt.digitalis.dif.sanitycheck.AbstractSanityCheckTestSuite;
import pt.digitalis.dif.sanitycheck.ExecutionResult;
import pt.digitalis.dif.sanitycheck.TestResult;
import pt.digitalis.dif.sanitycheck.annotations.SanityCheckTest;
import pt.digitalis.utils.ldap.LDAPGroup;
import pt.digitalis.utils.ldap.exception.LDAPOperationException;

/**
 * The Class CheckDIF2Groups.
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 24 de Fev de 2012
 */
public class CheckDIF2Groups extends AbstractSanityCheckTestSuite
{

    /** IdentityManager. */
    private final IdentityManagerLDAPImpl identityManagerImpl = new IdentityManagerLDAPImpl();

    /**
     * @see pt.digitalis.dif.sanitycheck.AbstractSanityCheckTestSuite#isActive()
     */
    @Override
    public boolean isActive()
    {
        return IdentityManagerLDAPImpl.NAME.equals(DIFDefaultModulesConfiguration.getInstance()
                .getDefaultImplementationIDFor(IIdentityManager.class));
    }

    /**
     * Test group parents.
     *
     * @return the test result
     *
     * @exception IdentityManagerException
     */
    @SanityCheckTest
    public TestResult testGroupParents() throws IdentityManagerException
    {
        String errorMessage = "";
        TestResult testResult;
        try
        {
            for (LDAPGroup group : identityManagerImpl.getLDAPUtils().findAllGroups())
            {
                if (!group.getParentGroupDN().equals(IdentityManagerLDAPImpl.N_A))
                {
                    try
                    {
                        identityManagerImpl.getLDAPUtils().findGroupByDistinguishedName(group.getParentGroupDN());
                    }
                    catch (Exception e)
                    {
                        errorMessage =
                                "Could not access parent group \"" + group.getParentGroupDN() + "\", of the group \"" +
                                group.getCommonName() + "\"! Exception: " + e.getMessage();
                    }
                }
            }
        }
        catch (LDAPOperationException e)
        {
            errorMessage = e.getMessage();
        }

        if (!"".equals(errorMessage))
        {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 2);
            testResult = new TestResult(ExecutionResult.FAILED);
            testResult.setErrorMessage(errorMessage);
        }
        else
        {
            testResult = new TestResult(ExecutionResult.PASSED);
        }

        return testResult;
    }
}