package pt.digitalis.dif.identity.ldap.util;

import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.dem.objects.messages.MessageList;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.ldap.exception.LDAPOperationSSLException;

import java.util.Map;

/**
 * @author Joo Galaio <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Oct 2, 2015
 */
public class LDAPExceptionTranslator
{

    /** the utility message cache */
    static private MessageList messageCache = null;

    /**
     * Inspector for the 'messages' attribute.
     *
     * @return the messages value
     */
    private static MessageList getMessageCache()
    {
        if (messageCache == null)
            messageCache = DIFIoCRegistry.getRegistry().getImplementation(IMessageManager.class)
                    .collectEntityMessagesFromRepository(LDAPExceptionTranslator.class);

        return messageCache;
    }

    /**
     * Translates the Exception error message
     *
     * @param exception
     * @param languageID
     *
     * @return error message
     */
    public static String translateErrorMessage(Exception exception, String languageID)
    {
        String resultMessage = "";
        Map<String, String> messages = LDAPExceptionTranslator.getMessageCache().getMessages(languageID);

        if (exception instanceof LDAPOperationSSLException)
        {
            resultMessage = messages.get("sslHashShakeMessage");
        }
        return resultMessage;
    }
}
