package pt.digitalis.dif.ioc;

import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.identity.ldap.IdentityManagerLDAPImpl;
import pt.digitalis.dif.identity.ldap.LDAPUtilsImplementation;
import pt.digitalis.dif.identity.ldap.sanitycheck.CheckDIF2Groups;
import pt.digitalis.dif.identity.ldap.sanitycheck.CheckDIF2LDAPConfigurations;
import pt.digitalis.dif.sanitycheck.ISanityCheckTestSuite;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;
import pt.digitalis.utils.ldap.ILDAPUtils;
import pt.digitalis.utils.ldap.impl.ad.LDAPUtilsActiveDirectoryImpl;
import pt.digitalis.utils.ldap.impl.openldap.LDAPUtilsOpenLDAPImpl;

/**
 * Module definition for the identity manager.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/04/21
 */
public class IdentityLDAPModule implements IIoCModule
{

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {

        binder.bind(IIdentityManager.class, IdentityManagerLDAPImpl.class).withId(IdentityManagerLDAPImpl.NAME)
                .asSingleton().override();
        binder.bind(ILDAPUtils.class, LDAPUtilsActiveDirectoryImpl.class).withId(LDAPUtilsImplementation.AD.getIdTag())
                .asSingleton();
        binder.bind(ILDAPUtils.class, LDAPUtilsOpenLDAPImpl.class).withId(LDAPUtilsImplementation.OPEN_LDAP.getIdTag())
                .asSingleton();

        // Discontinued from DIF1. Never implemented in DIF2!
        // binder.bind(ILDAPUtils.class,
        // LDAPUtilsOpenLDAPImpl.class).withId(LDAPUtilsImplementation.OID.getIdTag()).asSingleton();

        // Sanity checks
        binder.bind(ISanityCheckTestSuite.class, CheckDIF2LDAPConfigurations.class).withId("LDAPConfigurationsDIF2");
        binder.bind(ISanityCheckTestSuite.class, CheckDIF2Groups.class).withId("CheckDIF2Groups");
    }
}