/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl;

import java.util.List;
import java.util.Map;
import org.hibernate.Transaction;
import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.interfaces.IApplication;
import pt.digitalis.dif.dem.interfaces.IEntity;
import pt.digitalis.dif.dem.interfaces.IProvider;
import pt.digitalis.dif.dem.interfaces.IService;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.managers.impl.MessageManagerImpl;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.ICustomMessagesDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.CustomMessagesDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.CustomMessages;
import pt.digitalis.dif.dem.objects.messages.Message;
import pt.digitalis.dif.dem.objects.messages.MessageList;
import pt.digitalis.dif.dem.objects.messages.MessageTranslations;
import pt.digitalis.utils.common.StringUtils;

public class MessagesDatabaseManager
extends MessageManagerImpl {
    ICustomMessagesDAO theDAO = new CustomMessagesDAOImpl();

    public MessageList collectEntityMessagesFromRepository(Class<?> clazz) {
        MessageList messages = super.collectEntityMessagesFromRepository(clazz);
        messages = this.updateMessageListFromDatabase(messages, clazz.getSimpleName());
        return messages;
    }

    public MessageList collectEntityMessagesFromRepository(Entity type, Object instance) {
        MessageList messages = super.collectEntityMessagesFromRepository(type, instance);
        messages = this.updateMessageListFromDatabase(messages, ((IEntity)instance).getID());
        return messages;
    }

    public MessageList collectEntityMessagesFromRepository(String messagePath) {
        MessageList messages = super.collectEntityMessagesFromRepository(messagePath);
        messages = this.updateMessageListFromDatabase(messages, messagePath);
        return messages;
    }

    private List<CustomMessages> findAllWithEntityName(String entityName) {
        List customMessages = null;
        customMessages = DIFRepositoryFactory.getSession().createQuery("from CustomMessages customMessages where entityId like '%" + entityName + "%'").list();
        return customMessages;
    }

    private CustomMessages findByEntityAndMessageIDAndLanguage(String entityID, String messageID, String language) {
        CustomMessages result = null;
        List list = DIFRepositoryFactory.getSession().createQuery("from CustomMessages customMessages where entityId like '" + entityID + "' and " + "messageId" + " like '" + messageID + "'" + " and " + "language" + " = '" + language + "'").list();
        if (list.size() > 0) {
            result = (CustomMessages)list.get(0);
        }
        return result;
    }

    public boolean isPersistent() {
        return true;
    }

    private boolean isUpdatableMessage(Class<?> clazz, String messageID) {
        return this.collectEntityMessagesFromRepository(clazz).containsMessageWithID(messageID);
    }

    private boolean isUpdatableMessage(IEntity entity, String messageID) {
        Entity type = null;
        Class<?>[] interfaces = entity.getClass().getInterfaces();
        if (interfaces[0].equals(IProvider.class)) {
            type = Entity.PROVIDER;
        } else if (interfaces[0].equals(IApplication.class)) {
            type = Entity.APPLICATION;
        } else if (interfaces[0].equals(IService.class)) {
            type = Entity.SERVICE;
        } else if (interfaces[0].equals(IStage.class)) {
            type = Entity.STAGE;
        }
        return this.collectEntityMessagesFromRepository(type, entity).containsMessageWithID(messageID);
    }

    public void updateMessage(Class<?> clazz, String messageID, MessageTranslations message) {
        if (this.isUpdatableMessage(clazz, messageID)) {
            this.updateMessage(clazz.getSimpleName(), messageID, message);
        }
    }

    public void updateMessage(IEntity entity, String messageID, MessageTranslations message) {
        if (this.isUpdatableMessage(entity, messageID)) {
            this.updateMessage(this.getEntityID(entity), messageID, message);
        }
    }

    public void updateMessage(String entityID, String messageID, MessageTranslations message) {
        for (Map.Entry translation : message.getTranslations().entrySet()) {
            Transaction transaction = DIFRepositoryFactory.getSession().beginTransaction();
            CustomMessages messageOnDB = this.findByEntityAndMessageIDAndLanguage(entityID, messageID, (String)translation.getKey());
            if (messageOnDB == null) {
                if (StringUtils.isNotBlank((String)((Message)translation.getValue()).getMessage())) {
                    CustomMessages messageToFind = new CustomMessages();
                    messageToFind.setLanguage((String)translation.getKey());
                    messageToFind.setEntityId(entityID);
                    messageToFind.setMessageId(messageID);
                    messageToFind.setMessage(((Message)translation.getValue()).getMessage());
                    this.theDAO.persist(messageToFind);
                }
            } else if (((Message)translation.getValue()).isCustomized()) {
                messageOnDB.setMessage(((Message)translation.getValue()).getMessage());
                this.theDAO.merge(messageOnDB);
            } else {
                this.theDAO.delete(messageOnDB);
            }
            transaction.commit();
        }
        super.invalidateMessages();
    }

    private MessageList updateMessageListFromDatabase(MessageList messages, String entityName) {
        boolean wasActive = DIFRepositoryFactory.openTransaction();
        List<CustomMessages> customMessages = this.findAllWithEntityName(entityName);
        for (CustomMessages customMessage : customMessages) {
            String messageID = customMessage.getMessageId();
            String language = customMessage.getLanguage();
            Message message = messages.containsMessageWithID(customMessage.getMessageId()) && messages.getMessageTranslations(messageID).getMessage(language) != null ? new Message(messages.getMessageTranslations(messageID).getMessage(language).getDefaultMessage(), customMessage.getMessage()) : new Message(customMessage.getMessage());
            messages.addMessageTranslation(messageID, language, message);
        }
        if (!wasActive) {
            DIFRepositoryFactory.getSession().getTransaction().commit();
        }
        return messages;
    }
}

