package pt.digitalis.dif.ioc;

import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.dem.managers.impl.MessagesDatabaseManager;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * IoC module.
 *
 * @author Rodrigo Goncalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 */
public class MessageDatabaseModule implements IIoCModule
{

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {
        binder.bind(IMessageManager.class, MessagesDatabaseManager.class).withId("Database").asSingleton();
    }
}
