/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.http;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * Configuration point for the HTTP Controller.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Dec 23, 2007
 */
@ConfigID("dif2")
@ConfigSectionID("Controller/HTTP")
public class HTTPControllerConfiguration {

    /** The singleton instance property */
    private static HTTPControllerConfiguration instance;

    /**
     * Returns the active configuration object instance.
     * 
     * @return the configuration instance
     */
    @ConfigIgnore
    static public HTTPControllerConfiguration getInstance()
    {
        if (instance == null)
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(HTTPControllerConfiguration.class);
            }
            catch (Exception e)
            {
                instance = null;
            }

        return instance;
    }

    /** The error page for an inexistent stage */
    private String badStageStageID;

    /** Determines if cas is active or not */
    private Boolean centralAuthencication;

    /** The id of the default change password page */
    private String changePasswordID;

    /** The id of the stage do display on errors */
    private String dynamicErrorStageID;

    /** The id of the default home page */
    private String homeStageID;

    /** The path to the chart listener within the application */
    private String listenerChartName;

    /** The path to the document listener within the application */
    private String listenerDocName;

    /** The path to the listener within the application */
    private String listenerName;

    /** The id of the default login page */
    private String loginStageID;

    /** The id of the default logout page */
    // TODO: This will no longer be necessary since the logout will be managed by the dispatcher
    private String logoutStageID;

    /** The id of the default recovery password page */
    private String recoveryPasswordID;

    /** The id of the default recovery password url (will override the recoveryPasswordID) */
    private String recoveryPasswordURL;

    /** It defines if the registration stage is active or not */
    private Boolean registrationActive;

    /** The default Registration Stage id */
    private String registrationStageID;

    /** The URL to redirect for user registration (will override the registrationStageID) */
    private String registrationURL;

    /** The id of the default search page */
    private String searchStageID;

    /** Override server name discovery for cluster or virtual host environments */
    private String serverBaseURL;

    /** If T will allow language changes */
    private Boolean showChangeLanguage;

    /** If T will allow UI mode changes */
    private Boolean showChangeUIMode;

    /** If T will make the site map available in the default template */
    private Boolean showSiteMap;

    /** If T will make the sub footer available in the default template */
    private Boolean showSubFooter;

    /** The id of the default site map page */
    private String siteMapStageID;

    /** The path of the page (JSP/HTML) to display when all else fails on DIF */
    private String staticErrorPage;

    /** Uses the asset listener for compressing and caching the asset files. Otherwise, will render real the file path */
    private boolean useAssetListener;

    /**
     * Inspector for the 'badStageStageID' attribute.
     * 
     * @return the badStageStageID value
     */
    @ConfigDefault("errorstagebadstageid")
    public String getBadStageStageID()
    {
        return badStageStageID;
    }

    /**
     * Inspector for the 'centralAuthencication' attribute.
     * 
     * @return the centralAuthencication value
     */
    @ConfigDefault("false")
    public Boolean getCentralAuthencication()
    {
        return centralAuthencication;
    }

    /**
     * @return the changePasswordID
     */
    @ConfigDefault("changepasswordstage")
    public String getChangePasswordID()
    {
        return changePasswordID;
    }

    /**
     * Inspector for the dynamic error stage id property.
     * 
     * @return the dynamicErrorStageID value
     */
    @ConfigDefault("errorstage")
    public String getDynamicErrorStageID()
    {
        return this.dynamicErrorStageID;
    }

    /**
     * Inspector for the home stage id property.
     * 
     * @return the homeStageID value
     */
    @ConfigDefault("difhomestage")
    public String getHomeStageID()
    {
        return this.homeStageID;
    }

    /**
     * @return the listenerChartName
     */
    @ConfigDefault("chart")
    public String getListenerChartName()
    {
        return listenerChartName;
    }

    /**
     * @return the listenerDocName
     */
    @ConfigDefault("doc")
    public String getListenerDocName()
    {
        return listenerDocName;
    }

    /**
     * Inspector for the listener name property.
     * 
     * @return the listenerName value
     */
    @ConfigDefault("page")
    public String getListenerName()
    {
        return this.listenerName;
    }

    /**
     * Inspector for the login stage id property.
     * 
     * @return the loginStageID value
     */
    @ConfigDefault("loginstage")
    public String getLoginStageID()
    {
        return this.loginStageID;
    }

    /**
     * Inspector for the login stage id property.
     * 
     * @return the logoutStageID value
     */
    @ConfigDefault("logoutstage")
    public String getLogoutStageID()
    {
        return this.logoutStageID;
    }

    /**
     * Inspector for the recovery password stage id property.
     * 
     * @return the recoveryPasswordID value
     */
    @ConfigDefault("passwordrecoverystage")
    public String getRecoveryPasswordID()
    {
        return recoveryPasswordID;
    }

    /**
     * Inspector for the 'recoveryPasswordURL' attribute.
     * 
     * @return the recoveryPasswordURL value
     */
    public String getRecoveryPasswordURL()
    {
        return recoveryPasswordURL;
    }

    /**
     * Inspector for the 'registrationActive' attribute.
     * 
     * @return the registrationActive
     */
    @ConfigDefault("true")
    public Boolean getRegistrationActive()
    {
        return registrationActive;
    }

    /**
     * Inspector for the 'registrationStageID' attribute.
     * 
     * @return the searchStageID value
     */
    @ConfigDefault("RegistrationDisclaimer")
    public String getRegistrationStageID()
    {
        return registrationStageID;
    }

    /**
     * Inspector for the 'registrationURL' attribute.
     * 
     * @return the registragionURL value
     */
    public String getRegistrationURL()
    {
        return registrationURL;
    }

    /**
     * Inspector for the 'searchStageID' attribute.
     * 
     * @return the searchStageID value
     */
    @ConfigDefault("searchstage")
    public String getSearchStageID()
    {
        return searchStageID;
    }

    /**
     * Inspector for the 'serverBaseURL' attribute.
     * 
     * @return the serverBaseURL value
     */
    public String getServerBaseURL()
    {
        if (serverBaseURL != null && !"".equals(serverBaseURL))
            return serverBaseURL.replaceAll("\\\\", "/");
        else
            return serverBaseURL;
    }

    /**
     * Inspector for the 'showChangeLanguage' attribute.
     * 
     * @return the showChangeLanguage value
     */
    @ConfigDefault("true")
    public Boolean getShowChangeLanguage()
    {
        return showChangeLanguage;
    }

    /**
     * Inspector for the 'showChangeUIMode' attribute.
     * 
     * @return the showChangeUIMode value
     */
    @ConfigDefault("true")
    public Boolean getShowChangeUIMode()
    {
        return showChangeUIMode;
    }

    /**
     * Inspector for the 'showSiteMap' attribute.
     * 
     * @return the showSiteMap value
     */
    @ConfigDefault("false")
    public Boolean getShowSiteMap()
    {
        return showSiteMap;
    }

    /**
     * Inspector for the 'showSubFooter' attribute.
     * 
     * @return the showSubFooter value
     */
    @ConfigDefault("false")
    public Boolean getShowSubFooter()
    {
        return showSubFooter;
    }

    /**
     * Inspector for the 'siteMapStageID' attribute.
     * 
     * @return the siteMapStageID value
     */
    @ConfigDefault("sitemap")
    public String getSiteMapStageID()
    {
        return siteMapStageID;
    }

    /**
     * Inspector for the static error page property.
     * 
     * @return the staticErrorPage value
     */
    @ConfigDefault("internal/staticErrorPage.jsp")
    public String getStaticErrorPage()
    {
        return this.staticErrorPage;
    }

    /**
     * Inspector for the 'useAssetListener' attribute.
     * 
     * @return the useAssetListener value
     */
    @ConfigDefault("true")
    public boolean getUseAssetListener()
    {
        return useAssetListener;
    }

    /**
     * Modifier for the 'badStageStageID' attribute.
     * 
     * @param badStageStageID
     *            the new badStageStageID value to set
     */
    public void setBadStageStageID(String badStageStageID)
    {
        this.badStageStageID = badStageStageID;
    }

    /**
     * Modifier for the 'centralAuthencication' attribute.
     * 
     * @param centralAuthencication
     *            the new centralAuthencication value to set
     */
    public void setCentralAuthencication(Boolean centralAuthencication)
    {
        this.centralAuthencication = centralAuthencication;
    }

    /**
     * @param changePasswordID
     *            the changePasswordID to set
     */
    public void setChangePasswordID(String changePasswordID)
    {
        this.changePasswordID = changePasswordID;
    }

    /**
     * Modifier for the dynamic error stage id property.
     * 
     * @param dynamicErrorStageID
     *            the dynamicErrorStageID to set
     */
    public void setDynamicErrorStageID(String dynamicErrorStageID)
    {
        this.dynamicErrorStageID = dynamicErrorStageID;
    }

    /**
     * Modifier for the home stage id property.
     * 
     * @param homeStageID
     *            the homeStageID to set
     */
    public void setHomeStageID(String homeStageID)
    {
        this.homeStageID = homeStageID;
    }

    /**
     * @param listenerChartName
     *            the listenerChartName to set
     */
    public void setListenerChartName(String listenerChartName)
    {
        this.listenerChartName = listenerChartName;
    }

    /**
     * @param listenerDocName
     *            the listenerDocName to set
     */
    public void setListenerDocName(String listenerDocName)
    {
        this.listenerDocName = listenerDocName;
    }

    /**
     * Modifier for the listener name property.
     * 
     * @param listenerName
     *            the listenerName to set
     */
    public void setListenerName(String listenerName)
    {
        this.listenerName = listenerName;
    }

    /**
     * Modifier for the login stage id property.
     * 
     * @param loginStageID
     *            the loginStageID to set
     */
    public void setLoginStageID(String loginStageID)
    {
        this.loginStageID = loginStageID;
    }

    /**
     * Modifier for the logout stage id property.
     * 
     * @param logoutStageID
     *            the logoutStageID to set
     */
    public void setLogoutStageID(String logoutStageID)
    {
        this.logoutStageID = logoutStageID;
    }

    /**
     * Modifier for the recoveryPasswordID property
     * 
     * @param recoveryPasswordID
     *            the registrationActive to set
     */
    public void setRecoveryPasswordID(String recoveryPasswordID)
    {
        this.recoveryPasswordID = recoveryPasswordID;
    }

    /**
     * Modifier for the 'recoveryPasswordURL' attribute.
     * 
     * @param recoveryPasswordURL
     *            the new recoveryPasswordURL value to set
     */
    public void setRecoveryPasswordURL(String recoveryPasswordURL)
    {
        this.recoveryPasswordURL = recoveryPasswordURL;
    }

    /**
     * Modifier for the registrationActive property
     * 
     * @param registrationActive
     *            the registrationActive to set
     */
    public void setRegistrationActive(Boolean registrationActive)
    {
        this.registrationActive = registrationActive;
    }

    /**
     * Modifier for the Registration page id
     * 
     * @param registrationStageID
     *            the registrationStageID to set
     */
    public void setRegistrationStageID(String registrationStageID)
    {
        this.registrationStageID = registrationStageID;
    }

    /**
     * Modifier for the 'registrationURL' attribute.
     * 
     * @param registrationURL
     *            the new registrationURL value to set
     */
    public void setRegistrationURL(String registrationURL)
    {
        this.registrationURL = registrationURL;
    }

    /**
     * Modifier for the 'searchStageID' attribute.
     * 
     * @param searchStageID
     *            the new searchStageID value to set
     */
    public void setSearchStageID(String searchStageID)
    {
        this.searchStageID = searchStageID;
    }

    /**
     * Modifier for the 'serverBaseURL' attribute.
     * 
     * @param serverBaseURL
     *            the new serverBaseURL value to set
     */
    public void setServerBaseURL(String serverBaseURL)
    {
        this.serverBaseURL = serverBaseURL;
    }

    /**
     * Modifier for the 'showChangeLanguage' attribute.
     * 
     * @param showChangeLanguage
     *            the new showChangeLanguage value to set
     */
    public void setShowChangeLanguage(Boolean showChangeLanguage)
    {
        this.showChangeLanguage = showChangeLanguage;
    }

    /**
     * Modifier for the 'showChangeUIMode' attribute.
     * 
     * @param showChangeUIMode
     *            the new showChangeUIMode value to set
     */
    public void setShowChangeUIMode(Boolean showChangeUIMode)
    {
        this.showChangeUIMode = showChangeUIMode;
    }

    /**
     * Modifier for the 'showSiteMap' attribute.
     * 
     * @param showSiteMap
     *            the new showSiteMap value to set
     */
    public void setShowSiteMap(Boolean showSiteMap)
    {
        this.showSiteMap = showSiteMap;
    }

    /**
     * Modifier for the 'showSubFooter' attribute.
     * 
     * @param showSubFooter
     *            the new showSubFooter value to set
     */
    public void setShowSubFooter(Boolean showSubFooter)
    {
        this.showSubFooter = showSubFooter;
    }

    /**
     * Modifier for the 'siteMapStageID' attribute.
     * 
     * @param siteMapStageID
     *            the new siteMapStageID value to set
     */
    public void setSiteMapStageID(String siteMapStageID)
    {
        this.siteMapStageID = siteMapStageID;
    }

    /**
     * Modifier for the static error page property.
     * 
     * @param staticErrorPage
     *            the staticErrorPage to set
     */
    public void setStaticErrorPage(String staticErrorPage)
    {
        this.staticErrorPage = staticErrorPage;
    }

    /**
     * Modifier for the 'useAssetListener' attribute.
     * 
     * @param useAssetListener
     *            the new useAssetListener value to set
     */
    public void setUseAssetListener(boolean useAssetListener)
    {
        this.useAssetListener = useAssetListener;
    }
}
