/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.presentation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.annotations.AnnotationTags;
import pt.digitalis.dif.dem.annotations.metaannotations.AnnotationLogicClass;
import pt.digitalis.dif.dem.annotations.metaannotations.Primary;

/**
 * This annotation declares a captcha to a form. Can be used in a form submit method binded to the primary
 * {@link OnSubmit} annotation, or it can be used in a separated method, wich must return a boolean and that will allow
 * a custom logic to exist that determines if the captcha should be present in the form.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 02/07/2014
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Primary(yieldTo = "pt.digitalis.dif.dem.annotations.presentation.OnSubmit")
@AnnotationLogicClass("pt.digitalis.dif.dem.annotations.presentation.PresentationAnnotationLogic")
public @interface Captcha {

    /** Defines the view engine. Mandatory field! */
    String formName() default AnnotationTags.NONE;
}
