/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.listeners;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pt.digitalis.dif.controller.AbstractDIFDispatcher;
import pt.digitalis.dif.controller.interfaces.IDIFRequest;
import pt.digitalis.dif.controller.interfaces.IDIFResponse;
import pt.digitalis.dif.controller.objects.RESTAction;
import pt.digitalis.dif.exception.controller.ControllerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.presentation.renderers.interfaces.IViewServletRenderer;

import com.newrelic.api.agent.Trace;

/**
 * The listener for AJAX requests (HTTP channel).
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2008/09/08
 */
public class AJAXListener extends HttpListener {

    /**  */
    private static final long serialVersionUID = 14857394857879979L;

    /**
     * @see pt.digitalis.dif.listeners.HttpListener#processRequest(javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse, pt.digitalis.dif.controller.objects.RESTAction)
     */
    @Override
    @Trace(metricName = "DIF:AJAXListener", dispatcher = true)
    protected void processRequest(HttpServletRequest req, HttpServletResponse resp, RESTAction restAction)
            throws ServletException, IOException
    {
        // Serve the request
        IDIFResponse response = httpChal.serve(req, resp, restAction);

        // Get the renderer for the specified view engine and execute it...
        IViewServletRenderer renderer;

        if (response.getRequest() != null && "xml".equalsIgnoreCase(response.getRequest().getFormat()))
            // Requested XML format
            renderer = DIFIoCRegistry.getRegistry().getImplementation(IViewServletRenderer.class, "xml");
        else
            // Default JSON format
            renderer = DIFIoCRegistry.getRegistry().getImplementation(IViewServletRenderer.class, "ajax");

        try
        {
            renderer.renderView(response, getServletContext(), req, resp);

            AbstractDIFDispatcher.performCleanup(null, true);

        }
        catch (Exception exception)
        {
            try
            {
                AbstractDIFDispatcher.performCleanup(null, false);
            }
            catch (ControllerException e)
            {
                e.printStackTrace();
            }

            // Safeguard for Runtime exceptions that corrupt the response object
            IDIFRequest difRequest = response.getRequest();

            try
            {
                response = errorHandler.getDefaultErrorResponse(difRequest, exception);
            }
            catch (Exception e)
            {
                response = errorHandler.getDefaultErrorResponse(null, exception);
            }

            httpChal.publish(response, req, resp);

            // Get the renderer for the specified view engine and execute it...
            renderer = DIFIoCRegistry.getRegistry().getImplementation(IViewServletRenderer.class,
                    response.getView().getEngine());
            renderer.renderView(response, getServletContext(), req, resp);
        }
    }
}
