package pt.digitalis.dif.presentation.ajax;

import java.util.Map;

import pt.digitalis.dif.controller.interfaces.IDIFContext;

/**
 * Specification for a DiF JSON Response. This will be the base for all DIF Components required JSON responses, so the
 * CG process can handle them in a standard form
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 23 de Jul de 2013
 */
public interface IJSONRawResponse {

    /**
     * Parses the request JSON message body to get the data attributes to process
     * 
     * @param context
     *            the current execution context
     * @return the attributes map
     */
    public Map<String, String> getBeanAttributesFromJSONRequestBody(IDIFContext context);

    /**
     * @param context
     *            the current execution context
     * @return builds and returns the response
     */
    public abstract Map<String, Object> getResponse(IDIFContext context);

}