/**
 * 2012, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.ajax;

import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.controller.interfaces.IDIFContext;

/**
 * A normal map that the DiF Presentation layer will convert to direct JSON response instead of grouping all inside the
 * common result response value
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 23 de Jul de 2013
 */
public class JSONResponseMap extends HashMap<String, Object> implements IJSONRawResponse {

    /**
     * Created as a workaround to access the getBeanAttributesFromJSONRequestBody implementation
     * 
     * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
     * @created 06/03/2014
     */
    private class InnerJSONResponseObj extends AbstractJSONResponseCommon {

        /**
         * @see pt.digitalis.dif.presentation.ajax.IJSONRawResponse#getResponse(pt.digitalis.dif.controller.interfaces.IDIFContext)
         */
        public Map<String, Object> getResponse(IDIFContext context)
        {
            // Will not be used
            return null;
        }

    }

    /**  */
    private static final long serialVersionUID = 5014116719408237896L;

    /** */
    private InnerJSONResponseObj innerJSONResponseObj = new InnerJSONResponseObj();

    /**
     * @see pt.digitalis.dif.presentation.ajax.IJSONRawResponse#getBeanAttributesFromJSONRequestBody(pt.digitalis.dif.controller.interfaces.IDIFContext)
     */
    public Map<String, String> getBeanAttributesFromJSONRequestBody(IDIFContext context)
    {
        return this.innerJSONResponseObj.getBeanAttributesFromJSONRequestBody(context);
    }

    /**
     * @see pt.digitalis.dif.presentation.ajax.IJSONRawResponse#getResponse(pt.digitalis.dif.controller.interfaces.IDIFContext)
     */
    public Map<String, Object> getResponse(IDIFContext context)
    {
        return this;
    }
}
