/** 2009, Digitalis Informatica. All rights reserved.
 *
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.assets;



/**
 * An abstract implementation for an asset
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 24, 2009
 */
public abstract class AbstractAsset implements IAsset {

    /** T if the result asset response should be compressed */
    private boolean compressContent = true;

    /** the content type */
    private String contentType;

    /** Cache Expiration */
    private Long expirationInSeconds = 604800l;


    /**
     * @see pt.digitalis.dif.presentation.assets.IAsset#getCompressContent()
     */
    public boolean getCompressContent()
    {
        return compressContent;
    }

    /**
     * @see pt.digitalis.dif.presentation.assets.IAsset#getContentType()
     */
    public String getContentType()
    {
        return contentType;
    }

    /**
     * @see pt.digitalis.dif.presentation.assets.IAsset#getExpirationInSeconds()
     */
    public Long getExpirationInSeconds()
    {
        return expirationInSeconds;
    }

    /**
     * Modifier for the 'compressContent' attribute.
     *
     * @param compressContent the new compressContent value to set
     */
    public void setCompressContent(boolean compressContent)
    {
        this.compressContent = compressContent;
    }

    /**
     * Modifier for the 'contentType' attribute.
     *
     * @param contentType the new contentType value to set
     */
    public void setContentType(String contentType)
    {
        this.contentType = contentType;
    }


    /**
     * Modifier for the 'expirationInSeconds' attribute.
     *
     * @param expirationInSeconds the new expirationInSeconds value to set
     */
    public void setExpirationInSeconds(Long expirationInSeconds)
    {
        this.expirationInSeconds = expirationInSeconds;
    }
}
