/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.assets;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import pt.digitalis.dif.ioc.DIFIoCRegistry;

/**
 * The DIF Asset Manager
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 24, 2009
 */
public class AssetManager {

    /** The assets */
    private Map<String, IAsset> assets = null;

    /** Singleton instance */
    static private AssetManager instance = null;

    /**
     * Constructor
     */
    public AssetManager()
    {
        Map<String, IAssetProvider> providerMap = DIFIoCRegistry.getRegistry().getImplementationsMap(
                IAssetProvider.class);
        assets = new HashMap<String, IAsset>();

        for (IAssetProvider provider: providerMap.values())
            for (Entry<String, IAsset> entry: provider.getAssets().entrySet())
                addAsset(entry.getKey(), entry.getValue());
    }

    /**
     * Declares a new asset to the manager
     *
     * @param id
     *            the asset id
     * @param asset
     *            the asset to add
     */
    public void addAsset(String id, IAsset asset)
    {
        assets.put(id, asset);
    }

    /**
     * Returns an asset that is contained in the manager
     *
     * @param id
     *            the asset id to retrieve
     * @return the asset
     */
    public IAsset getAsset(String id)
    {
        return assets.get(id);
    }

    /**
     * Singleton instantiator for the assets manager
     *
     * @return the assets manager
     */
    static public AssetManager getInstance()
    {
        if (instance == null)
            instance = new AssetManager();

        return instance;
    }

    /**
     * Creates a new asset but does not add it to the manager Will parse for a prefix that identifies the asset type: -
     * context: A resoucre in the Webapp context - classpath: A resource in the classpath
     *
     * @param assetPath
     *            the path for the asset prefixed with the asset type
     * @return the created asset object
     */
    static public IAsset newAsset(String assetPath)
    {
        if (assetPath.startsWith(IAsset.ASSET_CONTEXT))
            return new WebappAsset(assetPath.substring(IAsset.ASSET_CONTEXT.length()));

        else if (assetPath.startsWith(IAsset.ASSET_CLASSPATH))
            return new ClassPathAsset(assetPath.substring(IAsset.ASSET_CLASSPATH.length()));

        else
            return new ClassPathAsset(assetPath);

    }
}
