/**
 * 2008, Digitalis Informatica. All rights reserved.
 *
 * Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone:
 * (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.documents;

import java.io.IOException;
import java.io.OutputStream;

import pt.digitalis.utils.documents.DocumentFactory;
import pt.digitalis.utils.documents.excel.ExcelDocument;

/**
 * An EXCEL HTTP Document response
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2008/11/24
 */
public class DocumentResponseEXCELImpl extends AbstractDocumentResponse {

    /** The data to write to the EXCEL document */
    ExcelDocument document = DocumentFactory.getExcelDocument(this.getFileName());

    /**
     * Default constructor
     *
     * @param fileName
     *            the document filename
     */
    public DocumentResponseEXCELImpl(String fileName) {
        super(fileName.toLowerCase().endsWith(".xls") ? fileName : fileName + ".xls");

        this.setDocumentType("application/vnd.ms-excel");
    }

    /**
     * @see pt.digitalis.dif.presentation.documents.IDocumentResponse#writeData(java.io.OutputStream)
     */
    public void writeData(OutputStream out) throws IOException {
        out.write(document.exportAsOutputStream().toByteArray());
    }

    /**
     * Inspector for the 'document' attribute.
     *
     * @return the document value
     */
    public ExcelDocument getDocument() {
        return document;
    }
}
