/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.documents;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * A generic HTTP Document response
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2009/05/04
 */
public class DocumentResponseGenericImpl extends AbstractDocumentResponse {

    /** The data to write to the document */
    InputStream data = null;

    /**
     * Default constructor
     *
     * @param fileName
     *            the document filename
     * @param mimeType
     *            the document mimeType
     */
    public DocumentResponseGenericImpl(String fileName, String mimeType)
    {
        super(fileName);

        this.setDocumentType(mimeType);
    }

    /**
     * Modifier for the 'data' attribute.
     *
     * @param data the new data value to set
     */
    public void setData(InputStream data)
    {
        this.data = data;
    }

    /**
     * @see pt.digitalis.dif.presentation.documents.IDocumentResponse#writeData(java.io.OutputStream)
     */
    public void writeData(OutputStream out) throws IOException
    {
        if (data != null)
        {
            byte[] buf = new byte[1024];
            int len;

            while ((len = data.read(buf)) > 0)
                out.write(buf, 0, len);
        }
    }
}
