/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.documents;

import java.io.IOException;
import java.io.OutputStream;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryEntry;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryException;
import pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager;

/**
 * A generic HTTP Document response
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2009/05/04
 */
public class DocumentResponseRepositoryImpl extends AbstractDocumentResponse {

    /** The data to write to the document */
    byte[] data;

    /**
     * Default constructor
     * 
     * @param docID
     *            the repository document id
     * @throws DocumentRepositoryException
     */
    public DocumentResponseRepositoryImpl(Long docID) throws DocumentRepositoryException
    {
        IDocumentRepositoryManager docRepository = DIFIoCRegistry.getRegistry().getImplementation(
                IDocumentRepositoryManager.class);
        DocumentRepositoryEntry doc = docRepository.getDocument(docID);
        super.setFileName(doc.getFileName());
        String mimeType = doc.getMimeType();

        if (mimeType != null)
        {
            mimeType = mimeType.toUpperCase().trim();

            if ("PDF".equals(mimeType))
                mimeType = "application/pdf";
            else if ("HTML".equals(mimeType))
                mimeType = "text/html";
            else if ("XML".equals(mimeType))
                mimeType = "text/xml";
            else
                mimeType = "application/octet-stream";
        }
        else
        {
            mimeType = "application/octet-stream";
        }

        super.setDocumentType(mimeType);
        this.data = doc.getBytes();
    }

    /**
     * @see pt.digitalis.dif.presentation.documents.IDocumentResponse#writeData(java.io.OutputStream)
     */
    public void writeData(OutputStream out) throws IOException
    {
        if (data != null)
        {
            out.write(data);
        }
    }
}
