/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.documents;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

import pt.digitalis.utils.documents.DocumentFactory;
import pt.digitalis.utils.documents.exception.DocumentException;
import pt.digitalis.utils.documents.template.FreemarkerDocument;

/**
 * An Template Engine HTTP Document response
 * 
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 2011/06/19
 */
public class DocumentResponseTemplateEngineImpl extends AbstractDocumentResponse {

    /** The Free Marker document */
    FreemarkerDocument document = null;

    /**
     * Private constructor for internal use.
     */
    private DocumentResponseTemplateEngineImpl()
    {
        this.setDocumentType("text/html");
    }

    /**
     * Default constructor
     * 
     * @param templatePath
     *            the template complete file path
     * @param properties
     * @throws IOException
     *             if an IO error occurrs
     */
    public DocumentResponseTemplateEngineImpl(String templatePath, Map<String, Object> properties) throws IOException
    {
        this();
        this.document = DocumentFactory.getFreeMarkerDocument(templatePath, properties);
    }

    /**
     * Constructor for DocumentResponseTemplateEngineImpl
     * 
     * @param templateName
     *            the tamplate name
     * @param template
     *            the Template
     * @param properties
     *            the rootMap
     * @throws IOException
     *             if an IO Exception occurrs
     */
    public DocumentResponseTemplateEngineImpl(String templateName, String template, Map<String, Object> properties)
            throws IOException
    {
        this();
        this.document = DocumentFactory.getFreeMarkerDocument(templateName, template, properties);
    }

    /**
     * Get the template result as string
     * 
     * @return the result as string
     * @throws DocumentException
     *             if an error occurs
     */
    public String getResultAsString() throws DocumentException
    {
        return this.document.exportAsString();
    }

    /**
     * @see pt.digitalis.dif.presentation.documents.IDocumentResponse#writeData(java.io.OutputStream)
     */
    public void writeData(OutputStream out) throws IOException
    {
        out.write(document.exportAsOutputStream().toByteArray());
    }

}
