/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.ioc;

import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.presentation.assets.IAsset;
import pt.digitalis.dif.presentation.assets.IAssetProvider;
import pt.digitalis.dif.presentation.assets.WebappAsset;

/**
 * Presentation layer assets
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 25, 2009
 */
public class PresentationAssets implements IAssetProvider {

    /**
     * @see pt.digitalis.dif.presentation.assets.IAssetProvider#getAssets()
     */
    public Map<String, IAsset> getAssets()
    {
        Map<String, IAsset> assets = new HashMap<String, IAsset>();

        // ExtJS 3.1
        assets.put("extJSBase_3.1.0.js", new WebappAsset("js/extjs_3.1/extjs/adapter/ext/ext-base.js"));
        assets.put("extJS_3.1.0-1.js", new WebappAsset("js/extjs_3.1/extjs/ext-all.js"));
        assets.put("extJS_3.1.0-1_debug.js", new WebappAsset("js/extjs_3.1/extjs/ext-all-debug.js"));

        // ExtJS 4.1
        assets.put("extJS-4.1.js", new WebappAsset("js/extjs_4.x/extjs/ext-all.js"));
        assets.put("extJS-4.1_debug.js", new WebappAsset("js/extjs_4.x/extjs/ext-all-dev.js"));

        // Alertify
        assets.put("alertify.js", new WebappAsset("js/extjs_4.x/alertify/alertify.min.js"));
        assets.put("alertify_debug.js", new WebappAsset("js/extjs_4.x/alertify/alertify.js"));

        // DIF
        /*
         * Ricardo Oliveira: as seguintes declaraes dos assets da DIF esto comentados devido a um problema com
         * mltiplos pedidos a um mesmo resource a partir do Internet Explorer (verses 7 e 8) Houve tambm a
         * necessidade de, na classe
         * pt.digitalis.dif.presentation.views.jsp.objects.contributions.WebUIJavascriptExtImpl efectuar a alterao da
         * chamamada ao asset para uma chamada directa ao JS ver bug #13371 para mais detalhes
         */
        /*
         * assets.put("difCustom_2.0.0B3-S1", new WebappAsset("js/difCustomComponents.js"));
         * assets.put("difChainedCombos_2.0.0B2-S1", new WebappAsset("js/chainedCombosExtImpl.js"));
         * assets.put("difElementActions_2.0.0B2-S1", new WebappAsset("js/elementActions.js"));
         */

        return assets;
    }

}
