/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.presentation.renderers.impl;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

import pt.digitalis.dif.controller.interfaces.IDIFResponse;
import pt.digitalis.dif.presentation.renderers.RendererConstants;
import pt.digitalis.dif.presentation.renderers.annotations.AllowedChannels;
import pt.digitalis.dif.presentation.renderers.interfaces.IViewServletRenderer;
import pt.digitalis.dif.utils.security.HTTPSecurityConfiguration;

import com.newrelic.api.agent.Trace;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 */
@AllowedChannels("http")
public class ViewRendererJSPImpl implements IViewServletRenderer {

    /**
     * @see pt.digitalis.dif.presentation.renderers.interfaces.IViewRenderer#renderView(pt.digitalis.dif.controller.interfaces.IDIFResponse)
     */
    public boolean renderView(IDIFResponse response)
    {
        // Nothing to do since the render process is a simple delegate of the servlet/jsp to run
        return false;
    }

    /**
     * @see pt.digitalis.dif.presentation.renderers.interfaces.IViewServletRenderer#renderView(pt.digitalis.dif.controller.interfaces.IDIFResponse,
     *      javax.servlet.ServletContext, javax.servlet.ServletRequest, javax.servlet.ServletResponse)
     */
    @Trace(metricName = "DIF:JSPViewRenderer", dispatcher = true)
    public boolean renderView(IDIFResponse response, ServletContext servletContext, ServletRequest servletRequest,
            ServletResponse servletResponse) throws ServletException, IOException
    {
        HttpServletResponse httpResponse = (HttpServletResponse) servletResponse;

        // Cancel cache to all JSP pages
        httpResponse.setHeader("Cache-Control", "no-cache");

        // Security headers
        try
        {
            HTTPSecurityConfiguration.getInstance().applyHTTPSecurityHeaders(httpResponse);
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }

        // Fetch the view path and process it if needed
        String viewPath = response.getView().getTarget();
        if (!viewPath.startsWith("/"))
        {
            viewPath = "/" + viewPath;
        }

        // Captures the charset defined by the main stage
        Object charsetProperty = servletRequest.getAttribute(RendererConstants.MAIN_RESPONSE_CHARSET);
        String charset;

        if (charsetProperty == null)
            charset = RendererConstants.DEFAULT_CHARSET;
        else
            charset = charsetProperty.toString();

        // Sets the charset since the included stage does not set the main response been returned, the listener servlet
        // one.
        servletResponse.setCharacterEncoding(charset);
        servletResponse.setContentType("text/html; charset=" + charset);

        RequestDispatcher dispatcher = servletContext.getRequestDispatcher(viewPath);

        dispatcher.include(servletRequest, servletResponse);

        return true;
    }

}
