/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.stages;

import javax.servlet.ServletException;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/08/11
 */
public abstract class AbstractErrorHandler {

    /**
     * @param <T>
     *            the generic exception class to find
     * @param exceptionClassToFind
     * @param exception
     * @return the exception within the stack or null if not found
     */
    @SuppressWarnings("unchecked")
    static public <T extends Exception> T getExceptionWithinStack(Class<T> exceptionClassToFind, Exception exception)
    {
        if (exception != null && exception instanceof ServletException)
            exception = (Exception) ((ServletException) exception).getRootCause();

        while (exception != null)
            if (exceptionClassToFind.isAssignableFrom(exception.getClass()))
                break;
            else
                exception = (T) exception.getCause();

        if (exception != null)
            return (T) exception;

        return null;
    }
}
