/**
 * - Digitalis Internal Framework v2.0 -
 *
 * (C) 2007, Digitalis Informatica.
 *
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.presentation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.annotations.metaannotations.AnnotationLogicClass;
import pt.digitalis.dif.dem.annotations.metaannotations.Primary;

/**
 * This annotation marks a method as the stage's execution method when a specific form is submitted.
 * It must be used on Stages only.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Jan 1, 2008
 *
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Primary
@AnnotationLogicClass("pt.digitalis.dif.dem.annotations.presentation.PresentationAnnotationLogic")
public @interface OnSubmitSaveAction {

    /** The name of the form to link to. */
    String value();
}
