/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.listeners;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pt.digitalis.dif.controller.AbstractDIFDispatcher;
import pt.digitalis.dif.controller.interfaces.IDIFRequest;
import pt.digitalis.dif.controller.interfaces.IDIFResponse;
import pt.digitalis.dif.controller.interfaces.IDispatcherErrorHandler;
import pt.digitalis.dif.controller.interfaces.IPrivateDIFSession;
import pt.digitalis.dif.controller.objects.RESTAction;
import pt.digitalis.dif.exception.controller.ControllerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.presentation.renderers.interfaces.IViewServletRenderer;
import pt.digitalis.dif.utils.logging.DIFLogger;

import com.newrelic.api.agent.Trace;

/**
 * The listener for the HTTP channel.
 * 
 * @author Rodrigo Goncalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/04/23
 */
public class HttpListener extends AbstractRESTfullHttpListener {

    /** The serial. */
    final static private long serialVersionUID = 5016965695982538616L;

    /** The associated error handler implementation. */
    protected IDispatcherErrorHandler errorHandler = DIFIoCRegistry.getRegistry().getImplementation(
            IDispatcherErrorHandler.class, "http");

    /**
     * @see pt.digitalis.dif.listeners.AbstractRESTfullHttpListener#processRequest(javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse, pt.digitalis.dif.controller.objects.RESTAction)
     */
    @Override
    @Trace(metricName = "DIF:HTTPListener", dispatcher = true)
    protected void processRequest(HttpServletRequest req, HttpServletResponse resp, RESTAction restAction)
            throws ServletException, IOException
    {
        // Serve the request
        IDIFResponse response = httpChal.serve(req, resp, restAction);

        if (response.getRequest() != null
                && response.getRequest().getParameters().get(IDIFRequest.REDIRECT_TO_URL) != null)
        {
            resp.sendRedirect(response.getRequest().getParameters().get(IDIFRequest.REDIRECT_TO_URL).toString());
        }
        else
        {
            IViewServletRenderer renderer = null;

            if (response.getView() != null)
            {
                // Get the renderer for the specified view engine and execute it...
                renderer = DIFIoCRegistry.getRegistry().getImplementation(IViewServletRenderer.class,
                        response.getView().getEngine());
            }

            if (renderer != null)
            {
                try
                {
                    renderer.renderView(response, getServletContext(), req, resp);
                    // The view execution time must be taken into account for session time out
                    if (response.getRequest() != null && response.getRequest().getSession() != null)
                    {
                        ((IPrivateDIFSession) response.getRequest().getSession()).forceKeepAlive();
                    }

                    AbstractDIFDispatcher.performCleanup(null, true);

                }
                catch (Exception exception)
                {
                    exception.printStackTrace();

                    DIFLogger.getLogger().info("Handling: " + exception.getMessage());

                    try
                    {
                        AbstractDIFDispatcher.performCleanup(null, false);
                    }
                    catch (ControllerException e)
                    {
                        e.printStackTrace();
                    }

                    // Safeguard for Runtime exceptions that corrupt the response object
                    IDIFRequest difRequest = null;
                    difRequest = response.getRequest();

                    try
                    {
                        response = errorHandler.getDefaultErrorResponse(difRequest, exception);
                        httpChal.publish(response, req, resp);
                    }
                    catch (Exception e)
                    {
                        response = errorHandler.getDefaultErrorResponse(null, exception);
                        httpChal.publish(response, req, resp);
                    }

                    // Get the renderer for the specified view engine and execute it...
                    renderer = DIFIoCRegistry.getRegistry().getImplementation(IViewServletRenderer.class,
                            response.getView().getEngine());
                    renderer.renderView(response, getServletContext(), req, resp);
                }
            }
        }
    }
}
