/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.assets;

import java.io.InputStream;

import javax.servlet.ServletContext;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 24, 2009
 */
public class ClassPathAsset extends AbstractAsset {

    /** The file in the class path */
    private String filePath;

    /**
     * @param filePath
     */
    public ClassPathAsset(String filePath)
    {
        this.filePath = filePath;
    }

    /**
     * @see pt.digitalis.dif.presentation.assets.IAsset#getResourceStream(javax.servlet.ServletContext)
     */
    public InputStream getResourceStream(ServletContext context)
    {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
    }
}
