/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.assets;

import java.io.InputStream;

import javax.servlet.ServletContext;

/**
 * Asset definition interface
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 24, 2009
 */
public interface IAsset {

    /** Classpath asset prefix */
    public static final String ASSET_CLASSPATH = "classpath:";

    /** Context asset prefix */
    public static final String ASSET_CONTEXT = "context:";

    /**
     * @param context
     *            the current servlet context
     * @return the asset as an output stream
     */
    public InputStream getResourceStream(ServletContext context);

    /**
     * @return the expiration time in seconds
     */
    public Long getExpirationInSeconds();

    /**
     * @return the content type for the asset
     */
    public String getContentType();

    /**
     * @return T if the results should be compressed
     */
    public boolean getCompressContent();
}
