/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.config;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * Configuration point for the Presentation layer
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 24, 2009
 */
@ConfigID("dif2")
@ConfigSectionID("Presentation")
public class PresentationConfiguration {

    /**  */
    public final static String CUSTOM_PREFIXED_BUNDLED_DIF_THEME_CSS = "css/css_diftemplate_theme_";

    /** The theme default value */
    public final static String DEFAULT_THEME = "none";

    /**  */
    public final static String DEFAULT_THEME_CSS = "css/css_diftemplate_theme.css";

    /** The singleton instance */
    static private PresentationConfiguration instance = null;

    /**
     * Returns the active configuration object instance.
     * 
     * @return the configuration instance
     */
    @ConfigIgnore
    static public PresentationConfiguration getInstance()
    {
        if (instance == null)
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(PresentationConfiguration.class);
            }
            catch (Exception e)
            {
                instance = null;
            }

        return instance;
    }

    /**
     * if Y will allow the forms to be configured. If N will forbid, and if D will only allow if the database repository
     * is available
     */
    private String allowConfigurableForms;

    /** If T will allow the use of collapsible areas. If F will disabled the show/hide feature. */
    private Boolean collapsibleAreas;

    /** End Date to show publicity in right Nav Bar */
    private String endShowPublicityDate;

    /** if T all dif forms will generate client side validation for it's parameter rules */
    private Boolean formClientSideValidationDefault;

    /** The JSP template. The Cascade Style Sheet file for the Print media. */
    private String httpCSSPrintTemplate;

    /** The JSP template. The Cascade Style Sheet file. */
    String httpCSSTemplate;

    /** The JSP template. The Cascade Style Sheet file for custom themes. */
    String httpCSSTemplateTheme;

    /** parameter to ignore the browser default language */
    private Boolean ignoreBrowserDefaultLanguage;

    /** Initial Date to show publicity in right Nav Bar */
    private String initialShowPublicityDate;

    /** the maximum Document size */
    private Integer maxDocumentSize;

    /** Location for Content */
    private String publicityContentLocation;

    /** Configuration value relative year reference */
    private String relativeYearReference;

    /** if T will attempt to save the presentation components state throughout different sessions of the same user */
    private Boolean saveComponentsState;

    /** the component state persistence timeout */
    private Long saveComponentsStateTimeout;

    /** Configuration value for template */
    private String templatePasswordRecoveryPolicy;

    /** The active theme */
    String theme;

    /**
     * Inspector for the 'allowConfigurableForms' attribute.
     * 
     * @return the allowConfigurableForms value
     */
    @ConfigDefault("D")
    public String getAllowConfigurableForms()
    {
        return allowConfigurableForms;
    }

    /**
     * Inspector for the 'maxDocumentSize' attribute.
     * 
     * @return the maxDocumentSize value
     */
    @ConfigDefault("true")
    public Boolean getCollapsibleAreas()
    {
        return collapsibleAreas;
    }

    /**
     * Inspector for the 'endShowPublicityDate' attribute.
     * 
     * @return the endShowPublicityDate value
     */
    @ConfigDefault("")
    public String getEndShowPublicityDate()
    {
        return endShowPublicityDate;
    }

    /**
     * Inspector for the 'formClientSideValidationDefault' attribute.
     * 
     * @return the formClientSideValidationDefault value
     */
    @ConfigDefault("true")
    public Boolean getFormClientSideValidationDefault()
    {
        return formClientSideValidationDefault;
    }

    /**
     * Inspector for the 'httpCSSPrintTemplate' attribute.
     * 
     * @return the httpCSSPrintTemplate value
     */
    @ConfigDefault("css/css_print.css")
    public String getHttpCSSPrintTemplate()
    {
        return httpCSSPrintTemplate;
    }

    /**
     * Inspector for the 'httpCSSTemplate' attribute.
     * 
     * @return the httpCSSTemplate value
     */
    @ConfigDefault("css/css_diftemplate.css")
    public String getHttpCSSTemplate()
    {
        return httpCSSTemplate;
    }

    /**
     * Inspector for the 'httpCSSTemplateTheme' attribute.
     * 
     * @return the httpCSSTemplateTheme value
     */
    @ConfigDefault(DEFAULT_THEME_CSS)
    public String getHttpCSSTemplateTheme()
    {
        return httpCSSTemplateTheme;
    }

    /**
     * Inspector for the 'ignoreBrowserDefaultLanguage' attribute.
     * 
     * @return the ignoreBrowserDefaultLanguage value
     */
    @ConfigDefault("false")
    public Boolean getIgnoreBrowserDefaultLanguage()
    {
        return ignoreBrowserDefaultLanguage;
    }

    /**
     * Inspector for the 'initialShowPublicityDate' attribute.
     * 
     * @return the initialShowPublicityDate value
     */
    @ConfigDefault("")
    public String getInitialShowPublicityDate()
    {
        return initialShowPublicityDate;
    }

    /**
     * Inspector for the 'maxDocumentSize' attribute.
     * 
     * @return the maxDocumentSize value
     */
    @ConfigDefault("1024")
    public Integer getMaxDocumentSize()
    {
        return maxDocumentSize;
    }

    /**
     * Inspector for the 'publicityContentLocation' attribute.
     * 
     * @return the publicityContentLocation value
     */
    @ConfigDefault("")
    public String getPublicityContentLocation()
    {
        return publicityContentLocation;
    }

    /**
     * Inspector for the 'relativeYearReference' attribute.
     * 
     * @return the relativeYearReference value
     */
    @ConfigDefault("50")
    public String getRelativeYearReference()
    {
        return relativeYearReference;
    }

    /**
     * Inspector for the 'saveComponentsState' attribute.
     * 
     * @return the saveComponentsState value
     */
    @ConfigDefault("true")
    public Boolean getSaveComponentsState()
    {
        return saveComponentsState;
    }

    /**
     * Inspector for the 'saveComponentsStateTimeout' attribute.
     * 
     * @return the saveComponentsStateTimeout value
     */
    @ConfigDefault("30")
    public Long getSaveComponentsStateTimeout()
    {
        return saveComponentsStateTimeout;
    }

    /**
     * Inspector for the 'templatePasswordRecoveryPolicy' attribute.
     * 
     * @return the templatePasswordRecoveryPolicy value
     */
    @ConfigDefault("templates/passwordrecovery.html")
    public String getTemplatePasswordRecoveryPolicy()
    {
        return templatePasswordRecoveryPolicy;
    }

    /**
     * Inspector for the 'httpCSSTemplateTheme' attribute.
     * 
     * @return the httpCSSTemplateTheme value
     */
    @ConfigDefault(DEFAULT_THEME)
    public String getTheme()
    {
        if (theme == null || DEFAULT_THEME.equalsIgnoreCase(theme))
        {
            return "greendif";
        }
        else
        {
            return theme;
        }
    }

    /**
     * @return T if a theme is selected. F is none.
     */
    @ConfigIgnore
    public boolean hasConfiguredTheme()
    {
        return (getTheme() != null && !"".equalsIgnoreCase(getTheme()) && !DEFAULT_THEME.equalsIgnoreCase(getTheme()));
    }

    /**
     * Modifier for the 'allowConfigurableForms' attribute.
     * 
     * @param allowConfigurableForms
     *            the new allowConfigurableForms value to set
     */
    public void setAllowConfigurableForms(String allowConfigurableForms)
    {
        this.allowConfigurableForms = allowConfigurableForms;
    }

    /**
     * Modifier for the 'collapsibleAreas' attribute.
     * 
     * @param collapsibleAreas
     *            the new collapsibleAreas value to set
     */
    public void setCollapsibleAreas(Boolean collapsibleAreas)
    {
        this.collapsibleAreas = collapsibleAreas;
    }

    /**
     * Modifier for the 'endShowPublicityDate' attribute.
     * 
     * @param endShowPublicityDate
     *            the new endShowPublicityDate value to set
     */
    public void setEndShowPublicityDate(String endShowPublicityDate)
    {
        this.endShowPublicityDate = endShowPublicityDate;
    }

    /**
     * Modifier for the 'formClientSideValidationDefault' attribute.
     * 
     * @param formClientSideValidationDefault
     *            the new formClientSideValidationDefault value to set
     */
    public void setFormClientSideValidationDefault(Boolean formClientSideValidationDefault)
    {
        this.formClientSideValidationDefault = formClientSideValidationDefault;
    }

    /**
     * Modifier for the 'httpCSSPrintTemplate' attribute.
     * 
     * @param httpCSSPrintTemplate
     *            the new httpCSSPrintTemplate value to set
     */
    public void setHttpCSSPrintTemplate(String httpCSSPrintTemplate)
    {
        this.httpCSSPrintTemplate = httpCSSPrintTemplate;
    }

    /**
     * Modifier for the 'httpCSSTemplate' attribute.
     * 
     * @param httpCSSTemplate
     *            the new httpCSSTemplate value to set
     */
    public void setHttpCSSTemplate(String httpCSSTemplate)
    {
        this.httpCSSTemplate = httpCSSTemplate;
    }

    /**
     * Modifier for the 'httpCSSTemplateTheme' attribute.
     * 
     * @param httpCSSTemplateTheme
     *            the new httpCSSTemplateTheme value to set
     */
    public void setHttpCSSTemplateTheme(String httpCSSTemplateTheme)
    {
        this.httpCSSTemplateTheme = httpCSSTemplateTheme;
    }

    /**
     * Modifier for the 'ignoreBrowserDefaultLanguage' attribute.
     * 
     * @param ignoreBrowserDefaultLanguage
     *            the new ignoreBrowserDefaultLanguage value to set
     */
    public void setIgnoreBrowserDefaultLanguage(Boolean ignoreBrowserDefaultLanguage)
    {
        this.ignoreBrowserDefaultLanguage = ignoreBrowserDefaultLanguage;
    }

    /**
     * Modifier for the 'initialShowPublicityDate' attribute.
     * 
     * @param initialShowPublicityDate
     *            the new initialShowPublicityDate value to set
     */
    public void setInitialShowPublicityDate(String initialShowPublicityDate)
    {
        this.initialShowPublicityDate = initialShowPublicityDate;
    }

    /**
     * Modifier for the 'maxDocumentSize' attribute.
     * 
     * @param maxDocumentSize
     *            the new maxDocumentSize value to set
     */
    public void setMaxDocumentSize(Integer maxDocumentSize)
    {
        this.maxDocumentSize = maxDocumentSize;
    }

    /**
     * Modifier for the 'publicityContentLocation' attribute.
     * 
     * @param publicityContentLocation
     *            the new publicityContentLocation value to set
     */
    public void setPublicityContentLocation(String publicityContentLocation)
    {
        this.publicityContentLocation = publicityContentLocation;
    }

    /**
     * Modifier for the 'relativeYearReference' attribute.
     * 
     * @param relativeYearReference
     *            the new relativeYearReference value to set
     */
    public void setRelativeYearReference(String relativeYearReference)
    {
        this.relativeYearReference = relativeYearReference;
    }

    /**
     * Modifier for the 'saveComponentsState' attribute.
     * 
     * @param saveComponentsState
     *            the new saveComponentsState value to set
     */
    public void setSaveComponentsState(Boolean saveComponentsState)
    {
        this.saveComponentsState = saveComponentsState;
    }

    /**
     * Modifier for the 'saveComponentsStateTimeout' attribute.
     * 
     * @param saveComponentsStateTimeout
     *            the new saveComponentsStateTimeout value to set
     */
    public void setSaveComponentsStateTimeout(Long saveComponentsStateTimeout)
    {
        this.saveComponentsStateTimeout = saveComponentsStateTimeout;
    }

    /**
     * Modifier for the 'templatePasswordRecoveryPolicy' attribute.
     * 
     * @param templatePasswordRecoveryPolicy
     *            the new templatePasswordRecoveryPolicy value to set
     */
    public void setTemplatePasswordRecoveryPolicy(String templatePasswordRecoveryPolicy)
    {
        this.templatePasswordRecoveryPolicy = templatePasswordRecoveryPolicy;
    }

    /**
     * @param theme
     */
    public void setTheme(String theme)
    {
        this.theme = theme;
    }

}
