/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.documents;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/**
 * Specifies a HTTP document to create
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2008/11/24
 */
public interface IDocumentResponse {

    /**
     * @return the document intended cache
     */
    String getCacheInfo();

    /**
     * @return the document charset
     */
    String getCharSet();

    /**
     * @return the document type
     */
    String getDocumentType();

    /**
     * @return the fileName value
     */
    String getFileName();

    /**
     * @return the document HTTP header contributions
     */
    Map<String, String> getHeaders();

    /**
     * Writes the data to the output stream
     * 
     * @param out
     *            the output stream
     * @throws IOException
     *             if an erro occured
     */
    void writeData(OutputStream out) throws IOException;
}
