/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.presentation.renderers.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

import pt.digitalis.dif.controller.http.JSONResponseBuilder;
import pt.digitalis.dif.controller.interfaces.IDIFResponse;
import pt.digitalis.dif.controller.interfaces.IDispatcherErrorHandler;
import pt.digitalis.dif.presentation.renderers.annotations.AllowedChannels;
import pt.digitalis.dif.presentation.renderers.interfaces.IViewServletRenderer;
import pt.digitalis.utils.common.StringUtils;

import com.newrelic.api.agent.Trace;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 */
@AllowedChannels("http")
public class ViewRendererJSONImpl implements IViewServletRenderer {

    /**
     * @see pt.digitalis.dif.presentation.renderers.interfaces.IViewRenderer#renderView(pt.digitalis.dif.controller.interfaces.IDIFResponse)
     */
    public boolean renderView(IDIFResponse response)
    {
        // Nothing to do since the render process is a simple delegate of the servlet/jsp to run
        return false;
    }

    /**
     * @see pt.digitalis.dif.presentation.renderers.interfaces.IViewServletRenderer#renderView(pt.digitalis.dif.controller.interfaces.IDIFResponse,
     *      javax.servlet.ServletContext, javax.servlet.ServletRequest, javax.servlet.ServletResponse)
     */
    @Trace(metricName = "DIF:JSONViewRenderer", dispatcher = true)
    public boolean renderView(IDIFResponse response, ServletContext servletContext, ServletRequest servletRequest,
            ServletResponse servletResponse) throws ServletException, IOException
    {
        /**
         * This value was change from ISO-8859-1 to UTF-8 to correct the problem reported on bug#20290. DISCLAIMER: But
         * isn't clear why it was in ISO-8859-1, so by resolving this problem maybe we are creating another. I create
         * this comment for future generations have the bases to decide the best Default charset.
         */
        String charset = "UTF-8"; // RendererConstants.DEFAULT_CHARSET;
        boolean callBackFunctionRequested = (StringUtils.isNotBlank(StringUtils.toStringOrNull(response.getRequest()
                .getParameter("callback"))));

        HttpServletResponse httpResponse = (HttpServletResponse) servletResponse;
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setCharacterEncoding(charset);
        httpResponse.setContentType("text/" + (callBackFunctionRequested ? "javascript" : "json") + "; charset="
                + charset);

        PrintWriter out = httpResponse.getWriter();

        StringBuffer buffer = new StringBuffer();

        // Get the stage execution results, where the JSON result has been stored...
        Map<String, Object> results = response.getStageResults();

        if (results.containsKey("JSONRaw"))
            // If a key JSONRaw exists, it will be assumed as the pre-built raw response, no conversion needed
            buffer.append(results.get("JSONRaw").toString());
        else if (results.containsKey("JSON"))
            // If a key JSON exists, it will be assumed as the pre-built response
            buffer.append(JSONResponseBuilder.buildJSONResponse(results.get("JSON")));
        else
        {
            // Otherwise parse the entire result map and output it to the stream
            // Remove special non-supported attributes
            results.remove(IDispatcherErrorHandler.ORIGINAL_REQUEST);
            results.remove(IDispatcherErrorHandler.EXCEPTION);

            // Add the parameter errors
            if (response.getStageInstance().getParameterErrors().hasErrors())
                results.put("parameterErrors", response.getStageInstance().getParameterErrors().getAllParameterErrors());

            // Add the authentication errors
            if (response.getStageInstance().getAuthenticationError() != null)
                results.put("authenticationError", response.getStageInstance().getAuthenticationError().getMessage());

            // If no success determined by the stage business, determine it by the existence of the previous errors
            // (authentication or parameters)
            if (results.get("success") == null)
                results.put("success", response.getStageInstance().getAuthenticationError() == null
                        && !response.getStageInstance().getParameterErrors().hasErrors());

            buffer.append(JSONResponseBuilder.buildJSONResponse(results));
        }

        if (callBackFunctionRequested)
        {
            String callbackfunctionName = response.getRequest().getParameter("callback").toString();
            buffer.insert(0, callbackfunctionName + " (");
            buffer.append("\n);");
        }

        out.println(buffer);
        out.close();

        return true;
    }
}
