/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.restfull;

/**
 * Defines a REST response
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/02/12
 */
public class RESTfullResponse {

    /** The data to return */
    private Object data;

    /** A message with details about the action performed and it's success */
    private String message;

    /** If the operation was successful */
    private Boolean success;

    /**
     * @param success
     * @param data
     */
    public RESTfullResponse(Boolean success, Object data)
    {
        super();
        this.success = success;
        this.data = data;
    }

    /**
     * @param message
     * @param success
     * @param data
     */
    public RESTfullResponse(String message, Boolean success, Object data)
    {
        super();
        this.message = message;
        this.success = success;
        this.data = data;
    }

    /**
     * Inspector for the 'data' attribute.
     *
     * @return the data value
     */
    public Object getData()
    {
        return data;
    }

    /**
     * Inspector for the 'message' attribute.
     *
     * @return the message value
     */
    public String getMessage()
    {
        return message;
    }

    /**
     * Inspector for the 'success' attribute.
     *
     * @return the success value
     */
    public Boolean getSuccess()
    {
        return success;
    }

    /**
     * Modifier for the 'data' attribute.
     *
     * @param data the new data value to set
     */
    public void setData(Object data)
    {
        this.data = data;
    }

    /**
     * Modifier for the 'message' attribute.
     *
     * @param message the new message value to set
     */
    public void setMessage(String message)
    {
        this.message = message;
    }

    /**
     * Modifier for the 'success' attribute.
     *
     * @param success the new success value to set
     */
    public void setSuccess(Boolean success)
    {
        this.success = success;
    }
}
