/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.http;

import com.google.inject.Inject;

import pt.digitalis.dif.controller.AbstractDIFDispatcher;
import pt.digitalis.dif.controller.objects.ControllerExecutionStep;
import pt.digitalis.dif.controller.security.managers.IAuthenticationManager;
import pt.digitalis.dif.controller.security.managers.IAuthorizationManager;
import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.controller.security.managers.ISessionManager;
import pt.digitalis.dif.dem.annotations.controller.Channel;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.exception.controller.ControllerException;
import pt.digitalis.utils.config.IConfigurations;

/**
 * This class is a specialization of AbstractDIFDispatcher for the HTTP-based channel. For this first prototype it uses
 * all the behavior defined on the base class so the class body is empty.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2007/03/27
 * @see AbstractDIFDispatcher
 */
@Channel("http")
public class DispatcherHTTPImpl extends AbstractDIFDispatcher {

    /**
     * the default constructor with the IoC injections
     * 
     * @param theIdentityManager
     * @param theAuthenticationManager
     * @param theAuthorizationManager
     * @param theSessionManager
     * @param theConfigurationManager
     */
    @Inject
    public DispatcherHTTPImpl(IIdentityManager theIdentityManager, IAuthenticationManager theAuthenticationManager,
            IAuthorizationManager theAuthorizationManager, ISessionManager theSessionManager,
            IConfigurations theConfigurationManager)
    {
        super(theIdentityManager, theAuthenticationManager, theAuthorizationManager, theSessionManager,
                theConfigurationManager);
    }

    /**
     * @see pt.digitalis.dif.controller.AbstractDIFDispatcher#handleNonAuthorizedAccess(pt.digitalis.dif.dem.interfaces.IStageInstance,
     *      pt.digitalis.dif.exception.controller.ControllerException)
     */
    @Override
    protected void handleNonAuthorizedAccess(IStageInstance stageInstance, ControllerException exception)
            throws ControllerException
    {
        if (exception.getStep() == ControllerExecutionStep.DISPATCHER_AUTHORIZATION
                && !difContext.getRequest().isAjaxMode())
        {
            HTTPControllerConfiguration config = theConfigurations.readConfiguration(HTTPControllerConfiguration.class);
            difContext.redirectTo(config.getLoginStageID());
            difContext.getRequest().addParameter(HTTPConstants.ON_SUCESS_LOGIN_STAGE,
                    difContext.getRequest().getStage());
            difContext.getRequest().addAttribute(HTTPConstants.ERROR_ATTRIBUTE, exception.getMessage());
        }
        else
            throw exception;
    }
}
