/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.http;

import java.util.List;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.CycleDetectionStrategy;
import pt.digitalis.dif.utils.annotations.JSONIgnore;

/**
 * Utility class to create an AJAX (JSON) response from different sources
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2008/09/07
 */
public class JSONResponseBuilder {

    /** The json config. */
    private static JsonConfig jsonConfig = new JsonConfig();

    static
    {
        jsonConfig.addIgnoreFieldAnnotation(JSONIgnore.class);
        jsonConfig.setCycleDetectionStrategy(CycleDetectionStrategy.LENIENT);
    }

    /**
     * Converts the given object to JSON representation
     * 
     * @param value
     *            to be converted
     * @return the JSON representation
     */
    static public String buildJSONResponse(boolean value)
    {
        return "" + Boolean.toString(value) + "";
    }

    /**
     * Converts the given object to JSON representation
     * 
     * @param list
     *            to be converted
     * @return the JSON representation
     */
    static public String buildJSONResponse(List<Object> list)
    {
        return JSONArray.fromObject(list, jsonConfig).toString();
    }

    /**
     * Converts the given map to JSON representation
     * 
     * @param map
     *            map to be converted
     * @return the JSON representation
     */
    static public String buildJSONResponse(Map<String, Object> map)
    {
        return JSONObject.fromObject(map, jsonConfig).toString();
    }

    /**
     * Converts the given object to JSON representation
     * 
     * @param value
     *            to be converted
     * @return the JSON representation
     */
    static public String buildJSONResponse(Object value)
    {
        return JSONObject.fromObject(value, jsonConfig).toString();
    }

    /**
     * Converts the given object to JSON representation
     * 
     * @param value
     *            to be converted
     * @return the JSON representation
     */
    static public String buildJSONResponse(String value)
    {
        return "\"" + value + "\"";
    }
}
