/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.annotations.presentation;

import pt.digitalis.dif.codegen.CGAncillaries;
import pt.digitalis.dif.codegen.util.ClassEnhancementContext;
import pt.digitalis.dif.dem.DEMAnnotationLogic;
import pt.digitalis.dif.exception.codegen.DIFCodeGenerationException;
import pt.digitalis.utils.bytecode.holders.AnnotationHolder;
import pt.digitalis.utils.bytecode.holders.AttributeHolder;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

/**
 * Instructs how to generate code for the GerEventos specific annotations
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 3 de Dez de 2012
 */
public class DDMAnnotationLogic extends DEMAnnotationLogic {

    /**
     * Copies behavior from the super class
     *
     * @param annotationFQName
     *            the annotation fully qualified name
     * @param annotationName
     *            the annotation name
     * @param isPrimary
     *            T if the annotation is primary
     */
    public DDMAnnotationLogic(String annotationFQName, String annotationName, boolean isPrimary)
    {
        super(annotationFQName, annotationName, isPrimary);
    }

    /**
     * @see pt.digitalis.dif.dem.DEMAnnotationLogic#addSourceCodeForAnnotation(pt.digitalis.dif.codegen.util.ClassEnhancementContext,
     *      pt.digitalis.utils.bytecode.holders.AnnotationHolder, pt.digitalis.utils.bytecode.holders.AttributeHolder)
     */
    @Override
    public void addSourceCodeForAnnotation(ClassEnhancementContext classEnhancementContext, AnnotationHolder annotation,
            AttributeHolder attribute) throws ResourceNotFoundException, DIFCodeGenerationException
    {
        // Get the attribute name
        String attributeName = attribute.getName();

        // Get annotation type name
        String annotationName = annotation.getName();

        // Get member values
        // Map<String, AnnotationMemberValueHolder> memberValues = annotation.getMembers();

        if (annotationName.equals(InjectDDMSession.class.getCanonicalName()))
        {
            // DIFContext is the 1st argument of EntityCGTemplate.DIF_INIT_METHOD_NAME
            classEnhancementContext.addEnhancement(CGAncillaries.STAGE_INSTANCE_ID,
                    CGAncillaries.STAGE_INJECTED_ATTRIBUTES_INIT_METHOD_NAME, "this." + attributeName
                            + "=pt.digitalis.dif.presentation.ddm.session.SessionUtil.newDDMSession(getContext());");
        }
    }
}
