/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.listeners;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pt.digitalis.dif.controller.interfaces.IChAL;
import pt.digitalis.dif.controller.objects.RESTAction;
import pt.digitalis.dif.ioc.DIFIoCRegistry;

/**
 * The listener for the HTTP channel.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2010/01/28
 */
public abstract class AbstractRESTfullHttpListener extends HttpServlet {

    /**  */
    private static final long serialVersionUID = 1308752358426404726L;

    /** The associated ChAL implementation. */
    @SuppressWarnings("unchecked")
    protected IChAL<HttpServletRequest, HttpServletResponse> httpChal = DIFIoCRegistry.getRegistry()
            .getImplementation(IChAL.class, "http");

    /**
     * @see javax.servlet.http.HttpServlet#doDelete(javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    @Override
    final protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        processRequest(req, resp, RESTAction.DELETE);
    }

    /**
     * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    @Override
    final protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        processRequest(req, resp, RESTAction.GET);
    }

    /**
     * Delegates the service request to the AbstractChAL and fetches the view for rendering from the response. Processes
     * the view information and forwards the view to the appropriate render.
     * 
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    @Override
    final protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        processRequest(req, resp, RESTAction.POST);
    }

    /**
     * @see javax.servlet.http.HttpServlet#doPut(javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    @Override
    final protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        processRequest(req, resp, RESTAction.PUT);
    }

    /**
     * Processes the request
     * 
     * @param req
     *            the HTTP request
     * @param resp
     *            the HTTP response
     * @param restAction
     *            the REST action
     * @throws ServletException
     * @throws IOException
     */
    abstract protected void processRequest(HttpServletRequest req, HttpServletResponse resp, RESTAction restAction)
            throws ServletException, IOException;
}
