package pt.digitalis.dif.listeners;

import java.io.IOException;
import java.util.Iterator;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pt.digitalis.dif.controller.objects.RESTAction;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Dec 13, 2010
 */
public class AuthenticationListener extends HttpListener {

    /** The Authentication Handler Servlet Mapping name */
    public static final String AUTHENTICATION_HANDLER = "AuthenticationHandler";

    /** Session name for last url */
    public static final String LAST_URL = "LAST_URL";
    /** The logout parameter */
    public static final String LOGOUT_PARAMETER = "logout";
    /** Serial Unique ID */
    private static final long serialVersionUID = 14817324857574979L;

    /** Service to redirect */
    public static final String SERVICE_TO_GO_BACK = "goBackTo";

    /**
     * Extract parameter from url
     * 
     * @param httpRequest
     * @return extracted url
     */
    @SuppressWarnings("unchecked")
    public static String extractUrl(HttpServletRequest httpRequest)
    {
        Iterator<String> keys = httpRequest.getParameterMap().keySet().iterator();
        String url = "";

        while (keys.hasNext())
        {
            String key = keys.next();
            if (!key.equals(SERVICE_TO_GO_BACK))
                url += "&" + key + "=" + httpRequest.getParameter(key);
        }
        return url;
    }

    /**
     * @see pt.digitalis.dif.listeners.HttpListener#processRequest(javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse, pt.digitalis.dif.controller.objects.RESTAction)
     */
    @Override
    protected void processRequest(HttpServletRequest req, HttpServletResponse resp, RESTAction restAction)
            throws ServletException, IOException
    {
        // System.out.println("---->" + req.getAttribute("Shib-Identity-Provider"));
        // System.out.println("---->" + req.getAttribute("Shib-Authentication-Instant"));
        // System.out.println("---->" + req.getAttribute("cn"));

        if (req.getParameter(SERVICE_TO_GO_BACK) != null)
        {
            String url = extractUrl(req);
            url = req.getParameter(SERVICE_TO_GO_BACK) + "?" + url.substring(1, url.length());
            resp.sendRedirect(url);
        }
    }

}
