/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.listeners;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pt.digitalis.dif.controller.http.HTTPControllerConfiguration;
import pt.digitalis.dif.listeners.objects.CharResponseWrapper;
import pt.digitalis.dif.listeners.objects.RESTHttpServletRequestWrapper;

/**
 * Will filter all requests in REST form, and converted to DIF's specific servlets with the corresponding parameters set
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/01/29
 * @see <a href="http://www.satyakomatineni.com/akc/display?url=displaynoteimpurl&ownerUserId=satya&reportId=2349">
 *      Filter example</a>
 * @see <a href="http://tuckey.org/urlrewrite/">A reusable servlet Filter API</a>
 */
public class RESTRequestsFilter implements Filter {

    /** The filter configuration */
    protected FilterConfig filterConfig = null;

    /**
     * @see javax.servlet.Filter#destroy()
     */
    public void destroy()
    {
        filterConfig = null;
    }

    /**
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse,
     *      javax.servlet.FilterChain)
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException
    {
        // The character encoding must be define before the first get parameter
        request.setCharacterEncoding(HTTPControllerConfiguration.getInstance().getCharset());

        RESTHttpServletRequestWrapper restRequest = new RESTHttpServletRequestWrapper((HttpServletRequest) request);
        restRequest.processRESTParameters();
        // Is a REST call to a page. Must correct the anchor links of the page so not to cause a page refresh, since
        // the base URL is different from the original REST page URL called
        if (restRequest.isRestCall() && restRequest.isPage())
        {

            PrintWriter out = response.getWriter();
            CharResponseWrapper wrapper = new CharResponseWrapper((HttpServletResponse) response);

            // Executes the request capturing the output in the response wrapper for later processing
            chain.doFilter(restRequest, wrapper);

            // If it is an HTML page, process it
            if (wrapper.getContentType().contains("text/html"))
            {
                CharArrayWriter caw = new CharArrayWriter();
                caw.write(wrapper.toString().replaceAll("\"#(.*)\"", "\"" + restRequest.getRequestURL() + "#$1\""));
                response.setContentLength(caw.toString().length());
                out.write(caw.toString());
            }
            // Otherwise, just dump it's output to the client, unchanged
            else
                out.write(wrapper.toString());
            out.close();

        }
        else
            chain.doFilter(restRequest, response);
    }

    /**
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
    public void init(FilterConfig filterConfig) throws ServletException
    {
        this.filterConfig = filterConfig;
    }

}
