/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.listeners.objects;

import java.io.CharArrayWriter;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/**
 * Response Wrapper to capture the response in a CharArrayWriter
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 4 de Out de 2012
 */
public class CharResponseWrapper extends HttpServletResponseWrapper {

    /**  */
    private CharArrayWriter output;

    /**
     * Default constructor
     * 
     * @param response
     */
    public CharResponseWrapper(HttpServletResponse response)
    {
        super(response);
        output = new CharArrayWriter();
    }

    /**
     * @see javax.servlet.ServletResponseWrapper#getWriter()
     */
    @Override
    public PrintWriter getWriter()
    {
        return new PrintWriter(output);
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        return output.toString();
    }
}
