/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.presentation.ajax;

import java.util.List;

/**
 * Generic result object. Used for return requests that must return a list of data that represents a subset of a larger
 * whole.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Jan 8, 2009
 */
public class FilteredResults {

    /** The filtered result set */
    private List<? extends Object> results;

    /** The total records prior to the filtering took place */
    private Long totalCount;

    /**
     * Default constructor
     *
     * @param results
     */
    public FilteredResults(List<? extends Object> results)
    {
        this.results = results;

        if (results != null)
            this.totalCount = new Integer(results.size()).longValue();
    }

    /**
     * Default constructor
     *
     * @param results
     * @param totalCount
     */
    public FilteredResults(List<? extends Object> results, Long totalCount)
    {
        this.results = results;
        this.totalCount = totalCount;
    }

    /**
     * @return the results
     */
    public List<? extends Object> getResults()
    {
        return results;
    }

    /**
     * @return the totalCount
     */
    public Long getTotalCount()
    {
        return totalCount;
    }

    /**
     * @param results
     *            the results to set
     */
    public void setResults(List<? extends Object> results)
    {
        this.results = results;
    }

    /**
     * @param totalCount
     *            the totalCount to set
     */
    public void setTotalCount(Long totalCount)
    {
        this.totalCount = totalCount;
    }
}
