/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.ajax;

import pt.digitalis.dif.controller.interfaces.IDIFContext;

/**
 * Specification for a DiF JSON Response. This will be the base for all DIF Components required JSON responses, so the
 * CG process can handle them in a standard form.<br/>
 * Sets some new methods from {@link IJSONResponse} for data collections representation
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2008/09/18
 */
public interface IJSONResponse extends IJSONRawResponse {

    /**
     * Returns the response in raw format. For direct access in nonAJAX modes
     * 
     * @param context
     *            the current execution context
     * @return a {@link FilteredResults} object
     */
    public FilteredResults getRawData(IDIFContext context);

    /**
     * @param context
     *            the current execution context
     * @return returns the response in raw format. For direct access in nonAJAX modes
     */
    public Long getRawDataCount(IDIFContext context);
}
