/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.assets;

import java.io.InputStream;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 24, 2009
 */
public class WebappAsset extends AbstractAsset {

    /** The file in the class path */
    private String filePath;

    /**
     * @param filePath
     */
    public WebappAsset(String filePath)
    {
        this.filePath = filePath;

        if (filePath.endsWith(".js"))
            setContentType("text/javascript");
    }

    /**
     * @see pt.digitalis.dif.presentation.assets.IAsset#getResourceStream(javax.servlet.http.HttpServletRequest,
     *      javax.servlet.ServletContext)
     */
    public InputStream getResourceStream(HttpServletRequest req, ServletContext context)
    {
        return context.getResourceAsStream(filePath);
    }
}
