/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.documents;

import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.presentation.renderers.CacheInfoConstants;
import pt.digitalis.dif.presentation.renderers.RendererConstants;

/**
 * A base implementation of an HTTP document response
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2008/11/24
 */
public abstract class AbstractDocumentResponse implements IDocumentResponse {

    /** Cache info */
    private String cacheInfo = CacheInfoConstants.NO_CACHE;

    /** The charset */
    private String charSet = RendererConstants.DEFAULT_CHARSET;

    /** The document type */
    private String documentType;

    /** The file name for the downloadable document file */
    private String fileName;

    /** The HTTP headers */
    private Map<String, String> headers = new HashMap<String, String>();

    /**
     * Default constructor
     */
    public AbstractDocumentResponse()
    {}

    /**
     * Default constructor
     * 
     * @param fileName
     */
    public AbstractDocumentResponse(String fileName)
    {
        setFileName(fileName);
    }

    /**
     * @see pt.digitalis.dif.presentation.documents.IDocumentResponse#getCacheInfo()
     */
    public String getCacheInfo()
    {
        return cacheInfo;
    }

    /**
     * @see pt.digitalis.dif.presentation.documents.IDocumentResponse#getCharSet()
     */
    public String getCharSet()
    {
        return charSet;
    }

    /**
     * @see pt.digitalis.dif.presentation.documents.IDocumentResponse#getDocumentType()
     */
    public String getDocumentType()
    {
        return documentType;
    }

    /**
     * @see pt.digitalis.dif.presentation.documents.IDocumentResponse#getFileName()
     */
    public String getFileName()
    {
        return fileName;
    }

    /**
     * @see pt.digitalis.dif.presentation.documents.IDocumentResponse#getHeaders()
     */
    public Map<String, String> getHeaders()
    {
        return this.headers;
    }

    /**
     * Modifier for the 'cacheInfo' attribute.
     * 
     * @param cacheInfo
     *            the new cacheInfo value to set
     */
    protected void setCacheInfo(String cacheInfo)
    {
        this.cacheInfo = cacheInfo;
    }

    /**
     * Modifier for the 'charSet' attribute.
     * 
     * @param charSet
     *            the new charSet value to set
     */
    protected void setCharSet(String charSet)
    {
        this.charSet = charSet;
    }

    /**
     * Modifier for the 'documentType' attribute.
     * 
     * @param documentType
     *            the new documentType value to set
     */
    protected void setDocumentType(String documentType)
    {
        this.documentType = documentType;
    }

    /**
     * Modifier for the 'fileName' attribute.
     * 
     * @param fileName
     *            the new fileName value to set
     */
    protected void setFileName(String fileName)
    {
        this.fileName = fileName;
    }

    /**
     * Modifier for the 'headers' attribute.
     * 
     * @param headers
     *            the new headers value to set
     */
    protected void setHeaders(Map<String, String> headers)
    {
        this.headers = headers;
    }
}
