/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.entities.system.difsso;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.utils.http.HttpUtils;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.crypto.exeption.CryptoException;
import pt.digitalis.utils.crypto.impl.EncryptorBase64Impl;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 02/09/2015
 */
public class SSOManager {

    /**
     * Token invalidator
     * 
     * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
     * @created 02/09/2015
     */
    private class TokenInvalidator extends Thread {

        /**
         * @see java.lang.Thread#run()
         */
        @Override
        public void run()
        {
            while (true)
            {
                try
                {
                    // Run every 10 seconds
                    sleep(10000);

                    for (SSOToken token: tokens.values())
                        try
                        {
                            if ((new Date().getTime()) - token.getTokenGenerationDate()
                                    .getTime() > (SSOSecurityConfiguration.getInstance().getTokenRetentionPeriod()
                                            * 1000))
                                tokens.remove(token);
                        }
                        catch (Exception e)
                        {
                            new BusinessException(e).addToExceptionContext("Token", token).log(LogLevel.ERROR);
                        }
                }
                catch (InterruptedException e1)
                {
                    e1.printStackTrace();
                }
            }
        }
    }

    /** the manager instance */
    private static SSOManager instance = null;

    /**
     * @return the instance of SSOManager
     */
    static synchronized public SSOManager getInstance()
    {
        if (instance == null)
        {
            instance = new SSOManager();
            instance.encrypter = new EncryptorBase64Impl();
            instance.encrypter.setSeed(HttpUtils.getApplicationTag() + HttpUtils.getVersion());
            instance.new TokenInvalidator().start();
        }

        return instance;
    }

    /**  */
    private EncryptorBase64Impl encrypter;

    /** the pending token list */
    private Map<String, SSOToken> tokens = new HashMap<String, SSOToken>();

    /**
     * @param stageID
     *            the stage id
     * @param userID
     *            the user id
     * @return the token ID generated
     * @throws CryptoException
     */
    public String generateTokenID(String stageID, String userID) throws CryptoException
    {
        return this.encrypter.encrypt("Stage#" + stageID + "|userID#" + userID);
    }

    /**
     * Returns the token if it exists and has not expired (expired token are discarded and this method will return null
     * 
     * @param id
     *            the token ID
     * @return the token if it exists
     */
    public SSOToken getTokenByID(String id)
    {
        SSOToken token = this.tokens.get(id);

        try
        {
            if (token.isExpired())
            {
                tokens.remove(token);
                token = null;
            }
        }
        catch (Exception e)
        {
            token = null;

            new BusinessException(e).addToExceptionContext("Token", token).log(LogLevel.ERROR);
        }

        return token;
    }

    /**
     * Create a new token
     * 
     * @param stageID
     *            the state Id to access
     * @param userID
     *            the user id to SSO
     * @return the generated token
     * @throws IllegalAccessException
     * @throws InstantiationException
     * @throws CryptoException
     */
    public SSOToken newToken(String stageID, String userID)
            throws InstantiationException, IllegalAccessException, CryptoException
    {
        SSOToken token = new SSOToken();
        token.setStageID(stageID);
        token.setTokenGenerationDate(new Date());
        token.setUserID(userID);
        token.setId(this.generateTokenID(stageID, userID));

        this.tokens.put(token.getId(), token);

        return token;

    }
}
